<?php
/**
 * Maintenance Mode Check
 * 
 * This file checks if the system is in maintenance mode.
 * If the .maintenance file exists in the root directory, 
 * users will be redirected to the maintenance page.
 * 
 * Admins with 'maintenance_bypass' session can still access the system.
 */

// Define the maintenance flag file path
$maintenance_file = dirname(__DIR__) . '/.maintenance';

// Check if maintenance mode is enabled
if (file_exists($maintenance_file)) {
    // Allow bypass for authorized users (super admins)
    $can_bypass = false;
    
    // Check if user has bypass permission
    if (isset($_SESSION['maintenance_bypass']) && $_SESSION['maintenance_bypass'] === true) {
        $can_bypass = true;
    }
    
    // Check if user is accessing the maintenance page itself or toggle scripts
    $current_script = basename($_SERVER['PHP_SELF']);
    $allowed_scripts = ['maintenance.html', 'maintenance-on.php', 'maintenance-off.php', 'logout.php'];
    
    if (in_array($current_script, $allowed_scripts)) {
        $can_bypass = true;
    }
    
    // Redirect to maintenance page if user cannot bypass
    if (!$can_bypass) {
        // Get the maintenance message if set
        $maintenance_message = file_get_contents($maintenance_file);
        if (empty(trim($maintenance_message))) {
            $maintenance_message = "We are currently performing scheduled maintenance. We'll be back shortly!";
        }
        
        // Store message in session for the maintenance page
        $_SESSION['maintenance_message'] = $maintenance_message;
        
        // Redirect to maintenance page
        header('Location: ' . BASE_URL . '/maintenance.html');
        exit();
    }
}
?>

