<?php
// Simple, reusable DB error logger used by endpoints during hosted diagnostics.
// Keeps messages generic for users and writes mysqli_error + backtrace to logs/db_debug.log
function log_db_error_global($con = null, $context = '') {
    $err = '';
    if ($con && function_exists('mysqli_error')) {
        $err = mysqli_error($con);
    }
    $bt = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 6);
    $bt_lines = [];
    foreach ($bt as $frame) {
        $file = isset($frame['file']) ? $frame['file'] : '(unknown)';
        $line = isset($frame['line']) ? $frame['line'] : 0;
        $func = isset($frame['function']) ? $frame['function'] : '(main)';
        $bt_lines[] = "$file:$line - $func";
    }
    $server = $_SERVER['HTTP_HOST'] ?? php_uname('n');
    $uri = $_SERVER['REQUEST_URI'] ?? '';
    $msg = "[".date('Y-m-d H:i:s')."] host={$server} uri={$uri} context={$context} error={$err}\nstack:\n".implode("\n", $bt_lines)."\n\n";
    $logdir = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'logs';
    if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
    @file_put_contents($logdir . DIRECTORY_SEPARATOR . 'db_debug.log', $msg, FILE_APPEND | LOCK_EX);
}

?>
