<?php
// Start session early to ensure session variables are available on all pages
if (session_status() === PHP_SESSION_NONE) {
      @session_start();
}

// Check maintenance mode (this must come after session start and before any output)
// require_once __DIR__ . '/maintenance.php';

// DB credentials from environment variables if available (hosted friendly), with sensible local fallbacks
$hostname = getenv('DB_HOST') ?: getenv('MYSQL_HOST') ?: 'localhost';
$username = getenv('DB_USER') ?: getenv('MYSQL_USER') ?: 'defenders_dev_user';
$password = getenv('DB_PASS') ?: getenv('MYSQL_PASS') ?: 'J~u1Y6G{~A=n';
$database = getenv('DB_NAME') ?: getenv('MYSQL_DB') ?: 'defenders_king_db';

// Create mysqli connection and set charset
$con = new mysqli($hostname, $username, $password, $database);
if ($con->connect_errno) {
      // Don't expose DB internals to end-users on hosted site. Log and show a generic message.
      error_log('Database connection error: ' . $con->connect_error);
      // If running from CLI or during setup, display a concise message
      if (php_sapi_name() === 'cli') {
            fwrite(STDERR, "Database connection error.\n");
      }
      // Terminate to avoid further errors
      die('Database connection error.');
}
// Ensure we use utf8mb4 for wide charset support
if (!@$con->set_charset('utf8mb4')) {
      error_log('Error setting DB charset: ' . $con->error);
}

// Date helpers
 $datenow = date('m/d/Y', time());
 $timenow = strtotime($datenow);

// BASE_URL: prefer explicit env var; otherwise try a reasonable default based on host and project folder
if (!defined('BASE_URL')) {
      $base_from_env = getenv('BASE_URL') ?: getenv('SCHOOL_SYS_BASE_URL');
      if (!empty($base_from_env)) {
            define('BASE_URL','https://02.ufanisiafrica.xyz');
      } else {
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || ($_SERVER['SERVER_PORT'] ?? 80) == 443 ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
            // try to infer project folder (parent of includes)
            $project = basename(dirname(__DIR__));
            define('BASE_URL', 'https://02.ufanisiafrica.xyz');
      }
}
//header("Content-type: text/html; charset=iso-8859-1");
if (!function_exists('getMonthName')) {
      function getMonthName($month)
      {
            switch ($month) {
                  case 1:
                        return 'January';
                        break;
                  case 2:
                        return 'February';
                        break;
                  case 3:
                        return 'March';
                        break;
                  case 4:
                        return 'April';
                        break;
                  case 5:
                        return 'May';
                        break;
                  case 6:
                        return 'June';
                        break;
                  case 7:
                        return 'July';
                        break;
                  case 8:
                        return 'August';
                        break;
                  case 9:
                        return 'September';
                        break;
                  case 10:
                        return 'October';
                        break;
                  case 11:
                        return 'November';
                        break;
                  case 12:
                        return 'December';
                        break;
            }
      }
}
       ?>