<?php
include '../includes/conn.php';
if (($_SESSION['schoolsyslevel'] != 4)) {
  header('Location:../login.php');
}

$class = $_GET['class'];
$split = explode('_', $class);
$class_id = current($split);
$stream_id = end($split);
$getclass =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
$row2 =  mysqli_fetch_array($getclass);
$class = $row2['class'];
$getstream =  mysqli_query($con, "SELECT * FROM streams WHERE stream_id='$stream_id'");
$row =  mysqli_fetch_array($getstream);
if (isset($row['stream'])) {
  $stream = $row['stream'];
} else {
  $stream = '';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo $class . ' ' . $stream; ?> TimeTable</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
  <?php include 'header.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              <?php echo $class . ' ' . $stream; ?> TimeTable
              <a href="printtimetable?class=<?php echo $class_id . '_' . $stream_id; ?>" class="btn  btn-info pull-right" target="_blank">Print</a>
            </header>
            <div class="panel-body">
              <?php
              // Compute current week dates for each day
              $today = new DateTime();
              $current_day_of_week = (int)$today->format('N'); // 1=Mon, 7=Sun
              $week_dates = [];
              $day_map = ['Mon'=>1, 'Tue'=>2, 'Wed'=>3, 'Thu'=>4, 'Fri'=>5, 'Sat'=>6, 'Sun'=>7];

              $getdays =  mysqli_query($con, "SELECT * FROM days");
              while ($roww = mysqli_fetch_array($getdays)) {
                $day = $roww['day'];
                $short = $roww['short'];
                // Calculate date for this day in current week
                $day_num = $day_map[ucfirst($short)] ?? 1;
                $offset = $day_num - $current_day_of_week;
                $day_date = (clone $today)->modify("{$offset} days")->format('Y-m-d');
                $week_dates[$short] = $day_date;
              ?>
                <h4 style="color: #333;font-weight: bold;text-transform: uppercase" class="pull-left"><?php echo $day; ?></h4>
                <?php
                $timetable =  mysqli_query($con, "SELECT * FROM `timetables` WHERE `class_id`='$class_id' AND `stream_id`='$stream_id' AND `day`='$short'  ORDER BY `position`");
                if (mysqli_num_rows($timetable) > 0) {
                ?>
                  <?php
                  // Show Edit to admins (schoolsyslevel == 1) or to class teachers for their own class
                  $is_admin = (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1);
                  $is_class_teacher = (isset($_SESSION['classteacher']) && $_SESSION['classteacher'] === 'yes');
                  $teacher_class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
                  if ($is_admin || ($is_class_teacher && $teacher_class_id === (int)$class_id)) {
                  ?>
                    <a href="edittimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>&&day=<?php echo $short; ?>" class="btn btn-sm btn-danger pull-right">Edit</a>
                  <?php } ?>
                  <table class="display table  table-bordered" style="margin-bottom: 20px;">
                    <thead>
                      <tr>
                        <?php
                        while ($row =  mysqli_fetch_array($timetable)) {
                          $starttime = $row['starttime'];
                          $endtime = $row['endtime'];
                        ?>
                          <th><?php echo $starttime . ' - ' . $endtime; ?></th>
                        <?php } ?>
                      </tr>
                    </thead>
                    <tbody>
                      <tr class="gradeA">
                        <?php
                        $timetable =  mysqli_query($con, "SELECT * FROM `timetables` WHERE `class_id`='$class_id' AND `stream_id`='$stream_id' AND `day`='$short' ORDER BY `position`");
                        while ($row =  mysqli_fetch_array($timetable)) {
                          $activity = $row['activity'];
                          $class_subjects = mysqli_query($con, "SELECT * FROM class_subjects WHERE class_sub_id='$activity'");
                          $row1 = mysqli_fetch_array($class_subjects);
                          if (mysqli_num_rows($class_subjects) > 0) {
                            $subject_id = $row1['subject_id'];
                            $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                            $row3 =  mysqli_fetch_array($getsubjects);
                            $subject = $row3['subject'];
                          }
                        ?>
                          <td>
                            <?php
                            $display_activity = '';
                            if (mysqli_num_rows($class_subjects) > 0) {
                              $display_activity = $subject;
                            } else {
                              $display_activity = $activity;
                            }
                            echo htmlspecialchars($display_activity, ENT_QUOTES);
                            ?>

                            <?php // show Find Substitute button to admins or the class teacher ?>
                            <?php if ($is_admin || ($is_class_teacher && $teacher_class_id === (int)$class_id)) { 
                              $starttime = $row['starttime'] ?? '';
                              $endtime = $row['endtime'] ?? '';
                              $cell_date = $week_dates[$short] ?? date('Y-m-d');
                            ?>
                              <div style="margin-top:6px;">
                                <button type="button" class="btn btn-xs btn-warning find-substitute-btn" 
                                  data-date="<?php echo htmlspecialchars($cell_date, ENT_QUOTES); ?>"
                                  data-starttime="<?php echo htmlspecialchars($starttime, ENT_QUOTES); ?>" 
                                  data-endtime="<?php echo htmlspecialchars($endtime, ENT_QUOTES); ?>" 
                                  data-class="<?php echo (int)$class_id; ?>" 
                                  data-stream="<?php echo (int)$stream_id; ?>" 
                                  data-activity="<?php echo htmlspecialchars($activity, ENT_QUOTES); ?>">
                                  Find Substitute
                                </button>
                              </div>
                            <?php } ?>
                          </td>
                        <?php } ?>
                      </tr>

                    </tbody>
                  </table>
                <?php } else { ?>
                  <div class="alert alert-danger pull-left" style="width: 100%">Timetable for <?php echo $day; ?> not added yet.
                    <?php
                    // Allow Add only to admins or the class teacher assigned to this class
                    if ($is_admin || ($is_class_teacher && $teacher_class_id === (int)$class_id)) {
                    ?>
                      Click <a href="addtimetable?cl=<?php echo $class_id; ?>&&st=<?php echo $stream_id; ?>&&day=<?php echo $short; ?>"><strong>HERE</strong></a> to Add
                    <?php } ?>
                  </div>
              <?php  }
              } ?>

            </div>
          </section>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <!-- Placed js at the end of the document so the pages load faster -->
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

  <!-- Find Substitute Modal -->
  <div id="findSubModal" class="modal" tabindex="-1" role="dialog" style="display:none;">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header" style="display:flex;align-items:center;justify-content:space-between;">
          <h5 class="modal-title">Find Substitute</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="jQuery('#findSubModal').hide();">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="findSubForm">
            <div class="form-group">
              <label>Date</label>
              <input type="date" name="date" class="form-control" required value="<?php echo date('Y-m-d'); ?>">
            </div>
            <div class="form-group">
              <label>Start Time</label>
              <input type="time" name="starttime" class="form-control" required>
            </div>
            <div class="form-group">
              <label>End Time</label>
              <input type="time" name="endtime" class="form-control" required>
            </div>
            <input type="hidden" name="class_id">
            <input type="hidden" name="stream_id">
            <input type="hidden" name="class_sub_id">
          </form>
          <div id="findSubResults" style="margin-top:12px;"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" onclick="jQuery('#findSubModal').hide();">Close</button>
        </div>
      </div>
    </div>
  </div>

  <script>
    jQuery(function($){
      $(document).on('click', '.find-substitute-btn', function(e){
        e.preventDefault();
        var btn = $(this);
        var date = btn.data('date') || new Date().toISOString().slice(0,10);
        var start = btn.data('starttime');
        var end = btn.data('endtime');
        var cls = btn.data('class');
        var st = btn.data('stream');
        var act = btn.data('activity');
        // Prefill modal
        var modal = $('#findSubModal');
        modal.find('input[name="date"]').val(date);
        modal.find('input[name="starttime"]').val(start);
        modal.find('input[name="endtime"]').val(end);
        modal.find('input[name="class_id"]').val(cls);
        modal.find('input[name="stream_id"]').val(st);
        modal.find('input[name="class_sub_id"]').val($.isNumeric(act) ? act : '');
        $('#findSubResults').html('');
        modal.show();
      });

      // Submit form to find substitutes
      $(document).on('change', '#findSubForm input, #findSubForm select', function(){
        // auto search when fields change
        var form = $('#findSubForm');
        var data = form.serialize();
        $('#findSubResults').html('Searching...');
        $.post('find_substitute.php', data, function(resp){
          if (resp.error) { $('#findSubResults').html('<div class="alert alert-danger">'+resp.error+'</div>'); return; }
          var html = '';
          if (resp.available && resp.available.length) {
            html += '<ul class="list-group">';
            resp.available.forEach(function(t){
              html += '<li class="list-group-item">' +
                '<strong>' + $('<div>').text(t.fullname).html() + '</strong> ' +
                ' (' + $('<div>').text(t.designation).html() + ') ' +
                '<button class="btn btn-xs btn-success pull-right assign-sub-btn" data-teacher="'+t.teacher_id+'">Assign</button>' +
                '</li>';
            });
            html += '</ul>';
          } else {
            html = '<div class="alert alert-info">No available teachers found.</div>';
          }
          $('#findSubResults').html(html);
        }, 'json').fail(function(){ $('#findSubResults').html('<div class="alert alert-danger">Request failed</div>'); });
      });

      // trigger initial search when modal shown
      $(document).on('click', '.find-substitute-btn', function(){ $('#findSubForm input').trigger('change'); });

      // Assign substitute
      $(document).on('click', '.assign-sub-btn', function(){
        var teacher_id = $(this).data('teacher');
        var form = $('#findSubForm');
        var data = form.serializeArray();
        data.push({name: 'substitute_teacher_id', value: teacher_id});
        // also include original teacher as null for now
        data.push({name: 'original_teacher_id', value: ''});
        $.post('assign_substitute.php', $.param(data), function(resp){
          if (resp.error) { $('#findSubResults').html('<div class="alert alert-danger">Error: '+resp.error+'</div>'); return; }
          var okHtml = '<div class="alert alert-success">Substitution recorded successfully. Reference ID: <strong>'+ (resp.substitution_id || '') +'</strong></div>';
          $('#findSubResults').html(okHtml);
          setTimeout(function(){ jQuery('#findSubModal').hide(); }, 1800);
          setTimeout(function(){ location.reload(); }, 2000);
        }, 'json').fail(function(){ alert('Request failed'); });
      });
    });
  </script>

</body>

</html>