<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
include __DIR__ . '/../includes/conn.php';

// Only Head of Section allowed here (view-only)
$level = (int)($_SESSION['schoolsyslevel'] ?? 0);
if ($level !== 4) {
    header('Location: login.php');
    exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$id = $id ? (int)$id : 0;
if ($id <= 0) {
    echo 'Invalid id';
    exit;
}

$sql = "SELECT m.midterm_plan_id, m.month, m.file_path, m.term, cs.class_id, cs.subject_id, c.class, s.subject, ft.term AS ft_term, ft.year AS ft_year
    FROM midterm_plans m
    JOIN class_subjects cs ON m.class_sub_id = cs.class_sub_id
    JOIN classes c ON cs.class_id = c.class_id
    JOIN subjects s ON cs.subject_id = s.subject_id
    LEFT JOIN financialterms ft ON ft.financialterm_id = m.term AND ft.status = 1
    WHERE m.midterm_plan_id = ? AND m.status = 1 LIMIT 1";

$stmt = mysqli_prepare($con, $sql);
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $row = $res ? mysqli_fetch_assoc($res) : null;
    mysqli_stmt_close($stmt);
} else {
    $row = null;
}

if (!$row) {
    echo 'Midterm plan not found';
    exit;
}

include __DIR__ . '/../includes/header.php';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Midterm Plan (Head) | <?php echo htmlspecialchars($row['subject'] . ' - ' . $row['class']); ?></title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8">
        <section class="panel">
          <header class="panel-heading"><?php echo htmlspecialchars($row['subject'] . ' : ' . $row['class']); ?> — Midterm Plan</header>
          <div class="panel-body">
            <table class="table table-striped">
              <tr><th>Month</th><td><?php echo htmlspecialchars($row['month']); ?></td></tr>
              <tr><th>Term</th><td><?php echo htmlspecialchars($row['ft_term'] ?? $row['term']); ?></td></tr>
              <tr><th>Year</th><td><?php echo htmlspecialchars($row['ft_year'] ?? ''); ?></td></tr>
            </table>
          </div>
        </section>
                <?php if (!empty($row['file_path'])): ?>
                    <?php
                        // Normalize the stored path and build a web-accessible URL
                        $pdf_path = ltrim($row['file_path'], '/\\');
                        $iframe_src = BASE_URL . '/' . $pdf_path;
                        // Build filesystem path to check existence (one level up from head/)
                        $file_path = dirname(__DIR__) . '/' . $pdf_path;
                    ?>
                    <section class="panel">
                        <header class="panel-heading">Midterm Plan Document</header>
                        <div class="panel-body">
              <?php if (file_exists($file_path)): ?>
                <div style="height:800px;">
                  <iframe src="<?php echo htmlspecialchars($iframe_src, ENT_QUOTES); ?>" width="100%" height="100%" style="border:none;" type="application/pdf"></iframe>
                </div>
                <p style="margin-top:10px;"><a href="<?php echo htmlspecialchars($iframe_src, ENT_QUOTES); ?>" target="_blank" class="btn btn-primary">Open in New Tab</a></p>
              <?php else: ?>
                <div class="alert alert-danger">
                  <strong>⚠ Document Not Found</strong><br>
                  The document file is missing from the server. Please contact the teacher to re-upload the document.
                </div>
              <?php endif; ?>
                        </div>
                    </section>
                <?php else: ?>
                    <div class="alert alert-info">No document uploaded for this midterm plan.</div>
                <?php endif; ?>
      </div>
    </div>
  </section>
</section>
</body>
</html>