<?php
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
include __DIR__ . '/../includes/conn.php';

// Only Head of Section allowed here (view-only)
$level = (int)($_SESSION['schoolsyslevel'] ?? 0);
if ($level !== 4) {
    header('Location: login.php');
    exit;
}

// fetch latest active cases
$cases = [];
$q = mysqli_query($con, "SELECT dc.*, s.fullname AS student_name, s.regnumber, t.fullname AS reporter_name FROM discipline_cases dc LEFT JOIN students s ON s.student_id = dc.student_id LEFT JOIN teachers t ON t.teacher_id = dc.reporter_id WHERE dc.status=1 ORDER BY dc.date DESC LIMIT 200");
if ($q) {
    while ($r = mysqli_fetch_assoc($q)) $cases[] = $r;
}

?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Discipline Cases (Head)</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
  <?php include 'header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-12">
        <section class="panel">
          <header class="panel-heading">Recent Discipline Cases</header>
          <div class="panel-body">
            <table class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>Student</th>
                  <th>Date</th>
                  <th>Type</th>
                  <th>Severity</th>
                  <th>Reporter</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($cases)): ?>
                  <tr><td colspan="6">No cases recorded.</td></tr>
                <?php else: ?>
                  <?php foreach ($cases as $c): ?>
                    <tr>
                      <td><?php echo htmlspecialchars($c['student_name'] . (trim((string)($c['regnumber'] ?? '')) !== '' ? ' (' . $c['regnumber'] . ')' : '')); ?></td>
                      <td><?php echo htmlspecialchars($c['date']); ?></td>
                      <td><?php echo htmlspecialchars($c['incident_type']); ?></td>
                      <td><?php echo (int)$c['severity']; ?></td>
                      <td><?php echo htmlspecialchars($c['reporter_name']); ?></td>
                      <td><a href="../teacher/discipline_details?id=<?php echo (int)$c['id']; ?>" class="btn btn-xs btn-default">View</a></td>
                    </tr>
                  <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
</body>
</html>
