<?php
include 'includes/conn.php';
$type=$_POST['type'];
if($type == 'fetch') {
    $events = array();
    $getevents = mysqli_query($con, "SELECT * FROM events WHERE status='1'");
    while($row = mysqli_fetch_array($getevents)) {
        $e = array();
        $start_ts = (int) ($row['startdate'] ?? 0);
        $end_ts = (int) ($row['enddate'] ?? 0);
        $eventname = $row['eventname'] ?? '';
        $event_id = $row['event_id'] ?? '';
        $description = $row['description'] ?? '';

        // sanitize title: remove HTML tags and collapse whitespace so calendar doesn't render HTML snippets
        $cleanTitle = strip_tags($eventname);
        $cleanTitle = html_entity_decode($cleanTitle, ENT_QUOTES | ENT_HTML5, 'UTF-8');
        $cleanTitle = trim(preg_replace('/\s+/', ' ', $cleanTitle));

        // To avoid month-view rendering issues with all-day exclusive end semantics and
        // timezone conversions, return timed events that span the full end day by
        // setting end to the end-date at 23:59:59 and allDay=false. This guarantees
        // the event bar covers the configured end date and no further.
        $start_date = $start_ts ? date('Y-m-d', $start_ts) : '';
        $end_date = $end_ts ? date('Y-m-d', $end_ts) : $start_date;

        $e['url'] = "event?id=" . $event_id;
        $e['id'] = $event_id;
        $e['title'] = $cleanTitle;
        // Timed ISO datetimes (no explicit timezone suffix). FullCalendar will treat
        // these as local times. Start at 00:00:00, end at 23:59:59 to include entire end day.
        $e['start'] = $start_date . 'T00:00:00';
        $e['end'] = $end_date . 'T23:59:59';
        $e['allDay'] = false;

        array_push($events, $e);
    }
    echo json_encode($events);
}
?>