<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canViewFinancialReports($user_level)) {
    header('Location:login.php');
    exit();
}

// Get date range for reports
$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Financial Reports Dashboard</title>
    <script src="js/jquery-1.10.2.min.js"></script>
    <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-bar-chart"></i> Financial Reports Dashboard
                        </h4>
                    </header>
                    <div class="panel-body">
                        <!-- Date Range Filter -->
                        <div class="row margin-bottom-20">
                                <div class="col-md-3">
                                <label>From Date:</label>
                                <input type="text" class="form-control default-date-picker" id="start_date" placeholder="Start Date" value="<?php echo $start_date; ?>" data-server-default="<?php echo $start_date; ?>">
                            </div>
                            <div class="col-md-3">
                                <label>To Date:</label>
                                <input type="text" class="form-control default-date-picker" id="end_date" placeholder="End Date" value="<?php echo $end_date; ?>" data-server-default="<?php echo $end_date; ?>">
                            </div>
                            <div class="col-md-3">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary btn-block" onclick="filterReports()">
                                    <i class="fa fa-filter"></i> Filter
                                </button>
                            </div>
                            <div class="col-md-3">
                                <label>&nbsp;</label>
                                <button class="btn btn-success btn-block" onclick="exportReports()">
                                    <i class="fa fa-download"></i> Export
                                </button>
                            </div>
                        </div>
                        
                        <!-- Quick Stats -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Total Income</h5>
                                    </div>
                                    <div class="panel-body">
                                        <?php
                                        $income_query = "SELECT COALESCE(SUM(amount_paid), 0) as total FROM accounts_receivable 
                                                       WHERE status IN ('Paid', 'Partial') 
                                                       AND DATE(updated_at) >= '$start_date' AND DATE(updated_at) <= '$end_date'";
                                        $income_result = mysqli_query($con, $income_query);
                                        if (!$income_result) {
                                            error_log('Income query error: ' . mysqli_error($con));
                                            $income_row = ['total' => 0];
                                        } else {
                                            $income_row = mysqli_fetch_array($income_result);
                                        }
                                        ?>
                                        <h3 class="text-success"><?php echo number_format($income_row['total'], 2); ?></h3>
                                        <small>Period: <?php echo $start_date; ?> to <?php echo $end_date; ?></small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-danger">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Total Expenses</h5>
                                    </div>
                                    <div class="panel-body">
                                        <?php
                                        $expenses_query = "SELECT COALESCE(SUM(amount), 0) as total FROM expenses 
                                                         WHERE status=1 
                                                         AND DATE(`date`) >= '$start_date' 
                                                         AND DATE(`date`) <= '$end_date'";
                                        $expenses_result = mysqli_query($con, $expenses_query);
                                        if (!$expenses_result) {
                                            error_log('Expenses query error: ' . mysqli_error($con));
                                            $expenses_row = ['total' => 0];
                                        } else {
                                            $expenses_row = mysqli_fetch_array($expenses_result);
                                        }
                                        ?>
                                        <h3 class="text-danger"><?php echo number_format($expenses_row['total'], 2); ?></h3>
                                        <small>Operational & Other</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Outstanding Payables</h5>
                                    </div>
                                    <div class="panel-body">
                                        <?php
                                        $payables_query = "SELECT COALESCE(SUM(amount - amount_paid), 0) as total FROM accounts_payable 
                                                         WHERE status NOT IN ('Paid', 'Cancelled')";
                                        $payables_result = mysqli_query($con, $payables_query);
                                        if (!$payables_result) {
                                            error_log('Payables query error: ' . mysqli_error($con));
                                            $payables_row = ['total' => 0];
                                        } else {
                                            $payables_row = mysqli_fetch_array($payables_result);
                                        }
                                        ?>
                                        <h3 class="text-info"><?php echo number_format($payables_row['total'], 2); ?></h3>
                                        <small>Vendor Invoices Due</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-warning">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Outstanding Receivables</h5>
                                    </div>
                                    <div class="panel-body">
                                        <?php
                                        $receivables_query = "SELECT COALESCE(SUM(amount - amount_paid), 0) as total FROM accounts_receivable 
                                                            WHERE status NOT IN ('Paid', 'Cancelled')";
                                        $receivables_result = mysqli_query($con, $receivables_query);
                                        if (!$receivables_result) {
                                            error_log('Receivables query error: ' . mysqli_error($con));
                                            $receivables_row = ['total' => 0];
                                        } else {
                                            $receivables_row = mysqli_fetch_array($receivables_result);
                                        }
                                        ?>
                                        <h3 class="text-warning"><?php echo number_format($receivables_row['total'], 2); ?></h3>
                                        <small>Student & Other</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Report Links -->
                        <div class="row margin-top-30">
                            <div class="col-md-6">
                                <section class="panel">
                                    <header class="panel-heading">
                                        <h4>Core Reports</h4>
                                    </header>
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <a href="balancesheet.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-file"></i> Balance Sheet
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="incomestatement.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-file"></i> Income Statement
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="cashflow.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-file"></i> Cash Flow Report
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="budgetanalysis.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-file"></i> Budget vs Actual Analysis
                                            </a>
                                        </li>
                                    </ul>
                                </section>
                            </div>
                            
                            <div class="col-md-6">
                                <section class="panel">
                                    <header class="panel-heading">
                                        <h4>Detailed Reports</h4>
                                    </header>
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <a href="feecollectionreport.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-money"></i> Fee Collection Report
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="payrollreport.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-money"></i> Payroll Report
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="vendorpaymentreport.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-money"></i> Vendor Payment Report
                                            </a>
                                        </li>
                                        <li class="list-group-item">
                                            <a href="audittrailreport.php?start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>">
                                                <i class="fa fa-shield"></i> Audit Trail Report
                                            </a>
                                        </li>
                                    </ul>
                                </section>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
<script>
function filterReports() {
    var startInput = document.getElementById('start_date');
    var endInput = document.getElementById('end_date');
    var start_date = (startInput && startInput.value) ? startInput.value : (startInput ? startInput.getAttribute('data-server-default') : '');
    var end_date = (endInput && endInput.value) ? endInput.value : (endInput ? endInput.getAttribute('data-server-default') : '');

    if (!start_date || !end_date) {
        alert('Please select both start and end dates');
        return;
    }

    var target = location.pathname || 'financialreports.php';
    var q = '?start_date=' + encodeURIComponent(start_date) + '&end_date=' + encodeURIComponent(end_date);
    location.href = target + q;
}

function exportReports() {
    var startInput = document.getElementById('start_date');
    var endInput = document.getElementById('end_date');
    var start_date = (startInput && startInput.value) ? startInput.value : (startInput ? startInput.getAttribute('data-server-default') : '');
    var end_date = (endInput && endInput.value) ? endInput.value : (endInput ? endInput.getAttribute('data-server-default') : '');
    if (start_date && end_date) {
        var target = location.pathname.replace(/\/+$/, '');
        // direct to export endpoint
        location.href = 'export_financial_reports.php?start_date=' + encodeURIComponent(start_date) + '&end_date=' + encodeURIComponent(end_date);
    } else {
        alert('Please select both start and end dates');
    }
}
</script>
</body>
</html>
