<?php
include 'includes/conn.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Fee Structures Plain Debug</title></head><body>
<h2>Fee Structures Plain Debug</h2>
<?php
echo '<p><a href="feestructures.php">Back to Fee Structures</a></p>';

// Count
$cntRes = @mysqli_query($con, "SELECT COUNT(*) AS cnt FROM fee_structures");
if (!$cntRes) {
    echo '<p style="color:red">COUNT query failed: ' . htmlspecialchars(mysqli_error($con)) . '</p>';
} else {
    $crow = mysqli_fetch_assoc($cntRes);
    echo '<p>COUNT: ' . ((int)($crow['cnt'] ?? 0)) . '</p>';
}

// Fetch rows
$res = @mysqli_query($con, "SELECT * FROM fee_structures ORDER BY fee_structure_id DESC");
if (!$res) {
    echo '<p style="color:red">SELECT failed: ' . htmlspecialchars(mysqli_error($con)) . '</p>';
    exit;
}

$rows = mysqli_num_rows($res);
echo '<p>Fetched rows: ' . (int)$rows . '</p>';

if ($rows > 0) {
    echo '<table border="1" cellpadding="6" cellspacing="0">';
    echo '<thead><tr>';
    // show column names
    $first = mysqli_fetch_assoc($res);
    $cols = array_keys($first);
    foreach ($cols as $c) echo '<th>' . htmlspecialchars($c) . '</th>';
    echo '</tr></thead>';
    echo '<tbody>';
    // print first row
    echo '<tr>'; foreach ($first as $v) echo '<td>' . htmlspecialchars((string)$v) . '</td>'; echo '</tr>';
    // remaining rows
    while ($r = mysqli_fetch_assoc($res)) {
        echo '<tr>'; foreach ($r as $v) echo '<td>' . htmlspecialchars((string)$v) . '</td>'; echo '</tr>';
    }
    echo '</tbody></table>';
} else {
    echo '<p>No rows found.</p>';
}

?>
</body></html>
