<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Check authorization (allow Accounts Management role 3 as well)
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 3) {
    header('Location:login.php');
    exit();
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Fee Structures</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-credit-card"></i> Fee Structures Management
                        </h4>
                    </header>
                    <div class="panel-body">


                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>



                        <a href="addfeestructure.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> Add New Fee Structure
                        </a>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Structure Name</th>
                                    <th>Academic Year</th>
                                    <th>Term</th>
                                    <th>Class</th>
                                    <th>Total Fee</th>
                                    <th>Status</th>
                                    <th>Created By</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Build a resilient query and handle missing columns/tables gracefully
                                $orderBy = 'fs.fee_structure_id DESC';
                                $colCheck = @mysqli_query($con, "SHOW COLUMNS FROM fee_structures LIKE 'created_at'");
                                if ($colCheck && mysqli_num_rows($colCheck) > 0) {
                                    $orderBy = 'fs.created_at DESC';
                                }

                                // Try the full query with joins first. If it fails (missing ref tables), fall back to a simple select.
                                $queryFull = "SELECT fs.*, y.year, t.term, c.class, u.username 
                                         FROM fee_structures fs 
                                         LEFT JOIN academicyears y ON fs.academic_year_id = y.academicyear_id
                                         LEFT JOIN financialterms t ON fs.term_id = t.financialterm_id
                                         LEFT JOIN classes c ON fs.class_id = c.class_id
                                         LEFT JOIN users u ON fs.created_by = u.user_id
                                         ORDER BY $orderBy";

                                $result = false;
                                $queryError = '';
                                
                                try {
                                    $result = mysqli_query($con, $queryFull);
                                } catch (mysqli_sql_exception $e) {
                                    // Capture the error and try a simpler query that only reads fee_structures
                                    $queryError = $e->getMessage();
                                    $fallback = "SELECT * FROM fee_structures ORDER BY fee_structure_id DESC";
                                    try {
                                        $result = mysqli_query($con, $fallback);
                                    } catch (mysqli_sql_exception $e2) {
                                        $result = false;
                                    }
                                }

                                if (!$result) {
                                    echo '<tr><td colspan="8"><div class="alert alert-warning">Could not load fee structures from database.</div></td></tr>';
                                } else {
                                    $fetchedCount = mysqli_num_rows($result);
                                    if ($fetchedCount === 0) {
                                        echo '<tr><td colspan="8"><div class="alert alert-info">No fee structures found.</div></td></tr>';
                                    } else {
                                        while ($row = mysqli_fetch_array($result)) {
                                            // When using fallback, some joined fields may not exist; use null coalescing
                                            $structure_name = $row['structure_name'] ?? '';
                                            $year = $row['year'] ?? ($row['academic_year_id'] ?? '-');
                                            $term = $row['term'] ?? ($row['term_id'] ?? '-');
                                            $class = $row['class'] ?? ($row['class_id'] ?? '-');
                                            $total_fee = isset($row['total_fee']) ? number_format($row['total_fee'], 2) : '0.00';
                                            $statusLabel = (isset($row['status']) && $row['status'] == 1) ? 'label-success' : 'label-danger';
                                            $statusText = (isset($row['status']) && $row['status'] == 1) ? 'Active' : 'Inactive';
                                            $username = $row['username'] ?? ($row['created_by'] ?? '-');

                                            echo '<tr>' .
                                                '<td>' . htmlspecialchars($structure_name) . '</td>' .
                                                '<td>' . htmlspecialchars($year) . '</td>' .
                                                '<td>' . htmlspecialchars($term) . '</td>' .
                                                '<td>' . htmlspecialchars($class) . '</td>' .
                                                '<td>' . $total_fee . '</td>' .
                                                '<td><span class="label ' . $statusLabel . '">' . $statusText . '</span></td>' .
                                                '<td>' . htmlspecialchars($username) . '</td>' .
                                                '<td>' .
                                                    '<a href="editfeestructure.php?id=' . ($row['fee_structure_id'] ?? '') . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a> ' .
                                                    '<a href="viewfeestructure.php?id=' . ($row['fee_structure_id'] ?? '') . '" class="btn btn-success btn-xs"><i class="fa fa-eye"></i> View</a>';

                                            if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) {
                                                echo ' <a href="deletefeestructure.php?id=' . ($row['fee_structure_id'] ?? '') . '" class="btn btn-danger btn-xs" onclick="return confirm(\'Are you sure?\')"><i class="fa fa-trash"></i> Delete</a>';
                                            }

                                            echo '</td></tr>';
                                        }
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
