<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Only Finance, Accounts, Super Admin, Principal can access
if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8,10])){
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Family Management - Sibling Discounts</title>
  <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

<section class="wrapper">
<div class="row">
    <div class="col-lg-12">
        <section class="panel">
            <header class="panel-heading">
                <h3><i class="fa fa-users"></i> Family Management & Sibling Discounts</h3>
                <p class="text-muted">Manage family groupings for automatic sibling discount calculation</p>
            </header>
            <div class="panel-body">
                
                <!-- Discount Policy Info -->
                <div class="alert alert-info">
                    <h4><i class="fa fa-info-circle"></i> Sibling Discount Policy</h4>
                    <ul>
                        <li><strong>2nd Child:</strong> 10% discount on school fees</li>
                        <li><strong>3rd Child & Additional Siblings:</strong> 20% discount on school fees</li>
                        <li><strong>Important:</strong> Discounts NOT applicable to nursery fees</li>
                        <li><strong>Automatic:</strong> Families are auto-detected when students share parent contact information</li>
                    </ul>
                </div>

                <!-- Statistics Cards -->
                <div class="row" style="margin-bottom: 20px;">
                    <?php
                        // Check if required tables exist
                        $familiesTableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
                        $calcTableCheck = mysqli_query($con, "SHOW TABLES LIKE 'student_fee_calculations'");
                    
                        $tablesExist = ($familiesTableCheck && mysqli_num_rows($familiesTableCheck) > 0) && 
                                       ($calcTableCheck && mysqli_num_rows($calcTableCheck) > 0);
                    
                        if (!$tablesExist) {
                            ?>
                            <div class="col-md-12">
                                <div class="alert alert-danger alert-block" style="margin: 20px 0;">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <h4><i class="fa fa-database"></i> Database Setup Required</h4>
                                    <p><strong>The family discount system tables have not been created yet.</strong></p>
                                    <p>Please follow these steps to set up the database:</p>
                                    <ol>
                                        <li>Open <strong>phpMyAdmin</strong> (usually at <a href="http://localhost/phpmyadmin" target="_blank">http://localhost/phpmyadmin</a>)</li>
                                        <li>Select your school database</li>
                                        <li>Click on the <strong>"SQL"</strong> tab</li>
                                        <li>Open the file: <code>sql/family_discount_enhancements.sql</code></li>
                                        <li>Copy all the SQL code and paste it into phpMyAdmin</li>
                                        <li>Click <strong>"Go"</strong> to execute</li>
                                    </ol>
                                    <p>For detailed instructions, see: <code>DATABASE_SETUP_REQUIRED.md</code> or <code>QUICK_START_GUIDE.md</code></p>
                                </div>
                            </div>
                            <?php
                            // Show the page structure but with no data
                            $totalFamilies = 0;
                            $eligibleFamilies = 0;
                            $discountStudents = 0;
                            $totalDiscountAmount = 0;
                        } else {
                    // Total families
                    $familiesQ = mysqli_query($con, "SELECT COUNT(*) as cnt FROM families WHERE status=1");
                    $familiesRow = mysqli_fetch_assoc($familiesQ);
                    $totalFamilies = $familiesRow['cnt'] ?? 0;
                    
                    // Families with 2+ children
                    $eligibleQ = mysqli_query($con, "SELECT COUNT(*) as cnt FROM families WHERE status=1 AND discount_eligible_count >= 2");
                    $eligibleRow = mysqli_fetch_assoc($eligibleQ);
                    $eligibleFamilies = $eligibleRow['cnt'] ?? 0;
                    
                    // Students receiving discounts
                    $discountStudentsQ = mysqli_query($con, "SELECT COUNT(*) as cnt FROM student_fee_calculations WHERE status=1 AND sibling_discount_percentage > 0");
                    $discStudRow = mysqli_fetch_assoc($discountStudentsQ);
                    $discountStudents = $discStudRow['cnt'] ?? 0;
                    
                    // Total discount amount this term
                    $currentTermQ = mysqli_query($con, "SELECT financialterm_id FROM financialterms WHERE status=1 ORDER BY financialterm_id DESC LIMIT 1");
                    $currentTermRow = mysqli_fetch_assoc($currentTermQ);
                    $currentTerm = $currentTermRow['financialterm_id'] ?? 0;
                    
                    $totalDiscountQ = mysqli_query($con, "SELECT SUM(sibling_discount_amount) as total FROM student_fee_calculations WHERE status=1 AND term_id=$currentTerm");
                    $totalDiscRow = mysqli_fetch_assoc($totalDiscountQ);
                    $totalDiscountAmount = $totalDiscRow['total'] ?? 0;
                    }
                    ?>
                    <div class="col-md-3">
                        <div class="panel panel-primary">
                            <div class="panel-body text-center">
                                <h3><?php echo number_format($totalFamilies); ?></h3>
                                <p>Total Families</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="panel panel-success">
                            <div class="panel-body text-center">
                                <h3><?php echo number_format($eligibleFamilies); ?></h3>
                                <p>Eligible for Discounts</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="panel panel-info">
                            <div class="panel-body text-center">
                                <h3><?php echo number_format($discountStudents); ?></h3>
                                <p>Students with Discounts</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="panel panel-warning">
                            <div class="panel-body text-center">
                                <h3>KSh <?php echo number_format($totalDiscountAmount); ?></h3>
                                <p>Total Discounts (Current Term)</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="btn-group" style="margin-bottom: 15px;">
                    <button class="btn btn-primary" onclick="recalculateAllFamilies()">
                        <i class="fa fa-refresh"></i> Recalculate All Families
                    </button>
                    <button class="btn btn-success" onclick="syncFamilyData()">
                        <i class="fa fa-sync"></i> Sync Family Data
                    </button>
                    <a href="family_discount_report.php" class="btn btn-info" target="_blank">
                        <i class="fa fa-file-pdf-o"></i> Generate Report
                    </a>
                </div>

                <!-- Families Table -->
                <table class="display table table-bordered table-striped" id="familiesTable">
                    <thead>
                        <tr>
                            <th>Family ID</th>
                            <th>Family Name</th>
                            <th>Primary Contact</th>
                            <th>Phone</th>
                            <th>Total Students</th>
                            <th>Eligible Students</th>
                            <th>Students</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            if ($tablesExist) {
                        // Get all families with student details
                        $familiesQuery = "SELECT 
                            f.family_id,
                            f.family_name,
                            f.primary_contact_name,
                            f.primary_contact_phone,
                            f.total_students,
                            f.discount_eligible_count,
                            GROUP_CONCAT(DISTINCT CONCAT(s.fullname, ' (', c.class, ')') ORDER BY s.student_id SEPARATOR '<br>') as students
                        FROM families f
                        LEFT JOIN students s ON s.family_id = f.family_id AND s.status = 1
                        LEFT JOIN classes c ON s.class_id = c.class_id
                        WHERE f.status = 1
                        GROUP BY f.family_id
                        ORDER BY f.family_id DESC";
                        
                        $result = mysqli_query($con, $familiesQuery);
                        
                        if ($result && mysqli_num_rows($result) > 0) {
                            while ($row = mysqli_fetch_assoc($result)) {
                                $eligibleBadge = $row['discount_eligible_count'] >= 2 ? 
                                    '<span class="label label-success">Eligible</span>' : 
                                    '<span class="label label-default">Not Eligible</span>';
                                ?>
                                <tr>
                                    <td><?php echo (int)$row['family_id']; ?></td>
                                    <td><?php echo htmlspecialchars($row['family_name'] ?? 'Family '.$row['family_id']); ?></td>
                                    <td><?php echo htmlspecialchars($row['primary_contact_name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['primary_contact_phone']); ?></td>
                                    <td class="text-center"><?php echo (int)$row['total_students']; ?></td>
                                    <td class="text-center">
                                        <?php echo (int)$row['discount_eligible_count']; ?> 
                                        <?php echo $eligibleBadge; ?>
                                    </td>
                                    <td><?php echo $row['students'] ?? 'No students'; ?></td>
                                    <td>
                                        <a href="family_details.php?id=<?php echo (int)$row['family_id']; ?>" 
                                           class="btn btn-info btn-xs">
                                            <i class="fa fa-eye"></i> View
                                        </a>
                                        <button onclick="editFamily(<?php echo (int)$row['family_id']; ?>)" 
                                                class="btn btn-warning btn-xs">
                                            <i class="fa fa-edit"></i> Edit
                                        </button>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            echo '<tr><td colspan="8" class="text-center">No families found. Families are created automatically when students with matching parent contacts are added.</td></tr>';
                        }
                            } else {
                                echo '<tr><td colspan="8" class="text-center alert alert-warning">Database tables not created yet. Please see the setup notice above.</td></tr>';
                            }
                        ?>
                    </tbody>
                </table>

            </div>
        </section>

        <!-- Students Without Families -->
        <section class="panel panel-warning">
            <header class="panel-heading">
                <h4><i class="fa fa-exclamation-triangle"></i> Students Not Assigned to Families</h4>
            </header>
            <div class="panel-body">
                <table class="display table table-bordered table-striped" id="noFamilyTable">
                    <thead>
                        <tr>
                            <th>Student Name</th>
                            <th>Reg Number</th>
                            <th>Class</th>
                            <th>Father Phone</th>
                            <th>Mother Phone</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $noFamilyQuery = "SELECT 
                            s.student_id,
                            s.fullname,
                            s.regnumber,
                            c.class,
                            s.fatherphone,
                            s.motherphone
                        FROM students s
                        JOIN classes c ON s.class_id = c.class_id
                        WHERE s.status = 1 
                        AND (s.family_id IS NULL OR s.family_id = 0)
                        ORDER BY s.fullname";
                        
                        $noFamilyResult = mysqli_query($con, $noFamilyQuery);
                        
                        if ($noFamilyResult && mysqli_num_rows($noFamilyResult) > 0) {
                            while ($row = mysqli_fetch_assoc($noFamilyResult)) {
                                ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['fullname']); ?></td>
                                    <td><?php echo htmlspecialchars($row['regnumber']); ?></td>
                                    <td><?php echo htmlspecialchars($row['class']); ?></td>
                                    <td><?php echo htmlspecialchars($row['fatherphone']); ?></td>
                                    <td><?php echo htmlspecialchars($row['motherphone']); ?></td>
                                    <td>
                                        <button onclick="findFamily(<?php echo (int)$row['student_id']; ?>)" 
                                                class="btn btn-primary btn-xs">
                                            <i class="fa fa-search"></i> Find Family
                                        </button>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            echo '<tr><td colspan="6" class="text-center text-success">All students are assigned to families!</td></tr>';
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </section>

    </div>
</div>
</section>

</section>

<!-- Scripts -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/scripts.js"></script>

<script>
$(document).ready(function() {
    // Only initialize DataTables if table has tbody with rows
    if ($('#familiesTable tbody tr').length > 0 && !$('#familiesTable tbody tr td').hasClass('dataTables_empty')) {
        // Avoid double initialization
        if (!$.fn.dataTable.isDataTable('#familiesTable')) {
            // Build columns fallback to avoid "Requested unknown parameter" errors
            var fCols = $('#familiesTable thead th').length;
            var fColsDef = [];
            for (var i=0;i<fCols;i++) { fColsDef.push({ data: null, defaultContent: '' }); }

            if ($.fn.dataTable && $.fn.dataTable.ext) { $.fn.dataTable.ext.errMode = 'console'; }

            $('#familiesTable').dataTable({
                "order": [[ 0, "desc" ]],
                "pageLength": 25,
                "columns": fColsDef,
                "columnDefs": [
                    { "orderable": false, "targets": 7 }, // Actions column not sortable
                    { "defaultContent": "", "targets": "_all" }
                ]
            });
        }
    }
    
    if ($('#noFamilyTable tbody tr').length > 0 && !$('#noFamilyTable tbody tr td').hasClass('dataTables_empty')) {
        $('#noFamilyTable').dataTable({
            "order": [[ 0, "asc" ]],
            "pageLength": 10,
            "columnDefs": [
                { "orderable": false, "targets": 5 } // Actions column not sortable
            ]
        });
    }
});

function recalculateAllFamilies() {
    if (confirm('This will recalculate all family groupings and discounts. Continue?')) {
        $.ajax({
            url: 'ajax/recalculate_families.php',
            type: 'POST',
            success: function(response) {
                alert('Family calculations updated successfully!');
                location.reload();
            },
            error: function() {
                alert('Error recalculating families. Please try again.');
            }
        });
    }
}

function syncFamilyData() {
    if (confirm('This will sync family data with student records. Continue?')) {
        $.ajax({
            url: 'ajax/sync_families.php',
            type: 'POST',
            success: function(response) {
                alert('Family data synchronized successfully!');
                location.reload();
            },
            error: function() {
                alert('Error synchronizing family data. Please try again.');
            }
        });
    }
}

function editFamily(familyId) {
    window.location.href = 'edit_family.php?id=' + familyId;
}

function findFamily(studentId) {
    if (confirm('Search for matching family based on parent contacts?')) {
        $.ajax({
            url: 'ajax/find_student_family.php',
            type: 'POST',
            data: { student_id: studentId },
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    alert('Family found and assigned! Student added to Family ID: ' + result.family_id);
                    location.reload();
                } else {
                    alert('No matching family found. This student may be the first in their family.');
                }
            },
            error: function() {
                alert('Error searching for family. Please try again.');
            }
        });
    }
}
</script>

</body>
</html>
