<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Only Finance, Accounts, Super Admin, Principal can access
if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8,10])){
    header('Location:login.php');
    exit;
}

$familyId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($familyId <= 0) {
    header('Location: familymanagement.php');
    exit;
}

// Ensure families table exists
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
if (!$tableCheck || mysqli_num_rows($tableCheck) === 0) {
    die('Families table not found. Please run sql/family_discount_enhancements.sql');
}

// Fetch family
$familyQ = mysqli_query($con, "SELECT * FROM families WHERE family_id=$familyId LIMIT 1");
$family = mysqli_fetch_assoc($familyQ);
if (!$family) {
    die('Family not found');
}

// Fetch students in family
$studentsQ = mysqli_query($con, "SELECT s.*, c.class FROM students s JOIN classes c ON s.class_id = c.class_id WHERE s.family_id=$familyId AND s.status=1 ORDER BY s.student_id");

// Fetch summary from calculations if table exists
$calcTableCheck = mysqli_query($con, "SHOW TABLES LIKE 'student_fee_calculations'");
$calcRows = [];
if ($calcTableCheck && mysqli_num_rows($calcTableCheck) > 0) {
    $calcQ = mysqli_query($con, "SELECT sfc.*, ft.term, ft.year, c.class AS class_name FROM student_fee_calculations sfc JOIN financialterms ft ON sfc.term_id = ft.financialterm_id JOIN classes c ON sfc.class_id = c.class_id WHERE sfc.family_id=$familyId AND sfc.status=1 ORDER BY sfc.student_id, sfc.term_id DESC");
    while ($r = mysqli_fetch_assoc($calcQ)) { $calcRows[] = $r; }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Family Details - ID <?php echo $familyId; ?></title>
  <link href="css/bootstrap.min.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-10 col-lg-offset-1">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-users"></i> Family Details (ID <?php echo $familyId; ?>)</h3>
            <a href="familymanagement.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back to Family Management</a>
          </header>
          <div class="panel-body">
            <div class="row">
              <div class="col-md-6">
                <h4><?php echo htmlspecialchars($family['family_name'] ?? ('Family '.$familyId)); ?></h4>
                <p><strong>Primary Contact:</strong> <?php echo htmlspecialchars($family['primary_contact_name']); ?></p>
                <p><strong>Phone:</strong> <?php echo htmlspecialchars($family['primary_contact_phone']); ?></p>
                <p><strong>Email:</strong> <?php echo htmlspecialchars($family['primary_contact_email']); ?></p>
                <?php if (!empty($family['secondary_contact_phone']) || !empty($family['secondary_contact_email'])): ?>
                <p><strong>Secondary Contact:</strong> <?php echo htmlspecialchars($family['secondary_contact_phone'].' '.$family['secondary_contact_email']); ?></p>
                <?php endif; ?>
                <p><strong>Address:</strong> <?php echo nl2br(htmlspecialchars($family['address'])); ?></p>
                <p><strong>Status:</strong> <?php echo ((int)$family['status']===1?'Active':'Inactive'); ?></p>
              </div>
              <div class="col-md-6">
                <p><strong>Total Students:</strong> <?php echo (int)$family['total_students']; ?></p>
                <p><strong>Eligible Students (non-nursery):</strong> <?php echo (int)$family['discount_eligible_count']; ?></p>
                <p><strong>Notes:</strong><br><?php echo nl2br(htmlspecialchars($family['notes'])); ?></p>
                <a class="btn btn-primary" href="edit_family.php?id=<?php echo $familyId; ?>"><i class="fa fa-edit"></i> Edit Family</a>
              </div>
            </div>

            <hr>
            <h4>Students in this Family</h4>
            <div class="table-responsive">
              <table class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Reg Number</th>
                    <th>Class</th>
                    <th>Phone (Father)</th>
                    <th>Phone (Mother)</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  if ($studentsQ && mysqli_num_rows($studentsQ)>0) {
                    $i=1;
                    while ($s = mysqli_fetch_assoc($studentsQ)) {
                      echo '<tr>'; 
                      echo '<td>'.($i++).'</td>'; 
                      echo '<td>'.htmlspecialchars($s['fullname']).'</td>'; 
                      echo '<td>'.htmlspecialchars($s['regnumber']).'</td>'; 
                      echo '<td>'.htmlspecialchars($s['class']).'</td>'; 
                      echo '<td>'.htmlspecialchars($s['fatherphone']).'</td>'; 
                      echo '<td>'.htmlspecialchars($s['motherphone']).'</td>'; 
                      echo '</tr>';
                    }
                  } else {
                    echo '<tr><td colspan="6" class="text-center">No students in this family.</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>

            <?php if (!empty($calcRows)) { ?>
            <hr>
            <h4>Fee Calculations (by Term)</h4>
            <div class="table-responsive">
              <table class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>Student</th>
                    <th>Term</th>
                    <th>Class</th>
                    <th>Base Fee</th>
                    <th>Sibling Disc %</th>
                    <th>Sibling Disc Amt</th>
                    <th>Early Disc</th>
                    <th>Late Penalty</th>
                    <th>Final Fee</th>
                    <th>Paid</th>
                    <th>Balance</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($calcRows as $r) { ?>
                    <tr>
                      <td><?php echo (int)$r['student_id']; ?></td>
                      <td><?php echo htmlspecialchars('Term '.$r['term'].' '.$r['year']); ?></td>
                      <td><?php echo htmlspecialchars($r['class_name']); ?></td>
                      <td><?php echo number_format($r['base_fee_amount'],2); ?></td>
                      <td><?php echo number_format($r['sibling_discount_percentage'],2); ?>%</td>
                      <td><?php echo number_format($r['sibling_discount_amount'],2); ?></td>
                      <td><?php echo number_format($r['early_payment_discount'],2); ?></td>
                      <td><?php echo number_format($r['late_payment_penalty'],2); ?></td>
                      <td><?php echo number_format($r['final_fee_amount'],2); ?></td>
                      <td><?php echo number_format($r['total_paid'],2); ?></td>
                      <td><?php echo number_format($r['balance'],2); ?></td>
                      <td><?php echo htmlspecialchars($r['payment_status']); ?></td>
                    </tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
            <?php } ?>

          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
