<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 2) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'add') {
        $facility_name = mysqli_real_escape_string($con, $_POST['facility_name'] ?? '');
        $facility_type = mysqli_real_escape_string($con, $_POST['facility_type'] ?? 'Building');
        $location = mysqli_real_escape_string($con, $_POST['location'] ?? '');
        $capacity = !empty($_POST['capacity']) ? (int) $_POST['capacity'] : 'NULL';
        $area_sqm = !empty($_POST['area_sqm']) ? (float) $_POST['area_sqm'] : 'NULL';
        $construction_year = !empty($_POST['construction_year']) ? (int) $_POST['construction_year'] : 'NULL';
        $last_renovation = !empty($_POST['last_renovation']) ? "'" . mysqli_real_escape_string($con, $_POST['last_renovation']) . "'" : 'NULL';
        $condition_status = mysqli_real_escape_string($con, $_POST['condition_status'] ?? 'Good');
        $status = !empty($_POST['status']) ? (int) $_POST['status'] : 1;
        $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
        
        $insert = "INSERT INTO facilities (facility_name, facility_type, location, capacity, area_sqm, 
                   construction_year, last_renovation, condition_status, status, notes) 
                   VALUES ('$facility_name', '$facility_type', '$location', $capacity, $area_sqm, 
                   $construction_year, $last_renovation, '$condition_status', $status, '$notes')";
        
        if (mysqli_query($con, $insert)) {
            $_SESSION['message'] = 'Facility added successfully';
        } else {
            $_SESSION['error'] = 'Error adding facility: ' . mysqli_error($con);
        }
    } elseif ($_POST['action'] === 'edit') {
        $facility_id = (int) $_POST['facility_id'];
        $facility_name = mysqli_real_escape_string($con, $_POST['facility_name'] ?? '');
        $facility_type = mysqli_real_escape_string($con, $_POST['facility_type'] ?? 'Building');
        $location = mysqli_real_escape_string($con, $_POST['location'] ?? '');
        $capacity = !empty($_POST['capacity']) ? (int) $_POST['capacity'] : 'NULL';
        $area_sqm = !empty($_POST['area_sqm']) ? (float) $_POST['area_sqm'] : 'NULL';
        $construction_year = !empty($_POST['construction_year']) ? (int) $_POST['construction_year'] : 'NULL';
        $last_renovation = !empty($_POST['last_renovation']) ? "'" . mysqli_real_escape_string($con, $_POST['last_renovation']) . "'" : 'NULL';
        $condition_status = mysqli_real_escape_string($con, $_POST['condition_status'] ?? 'Good');
        $status = !empty($_POST['status']) ? (int) $_POST['status'] : 1;
        $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
        
        $update = "UPDATE facilities SET facility_name='$facility_name', facility_type='$facility_type', 
                   location='$location', capacity=$capacity, area_sqm=$area_sqm, construction_year=$construction_year, 
                   last_renovation=$last_renovation, condition_status='$condition_status', status=$status, notes='$notes' 
                   WHERE facility_id=$facility_id";
        
        if (mysqli_query($con, $update)) {
            $_SESSION['message'] = 'Facility updated successfully';
        } else {
            $_SESSION['error'] = 'Error updating facility: ' . mysqli_error($con);
        }
    } elseif ($_POST['action'] === 'delete') {
        $facility_id = (int) $_POST['facility_id'];
        $update = "UPDATE facilities SET status=0 WHERE facility_id=$facility_id";
        if (mysqli_query($con, $update)) {
            $_SESSION['message'] = 'Facility deactivated successfully';
        } else {
            $_SESSION['error'] = 'Error deactivating facility: ' . mysqli_error($con);
        }
    }
    header('Location: facilities.php');
    exit;
}

$facilities_query = "SELECT * FROM facilities ORDER BY status DESC, facility_name ASC";
$facilities_result = mysqli_query($con, $facilities_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Facilities Management - School Manager</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <style>
        .condition-excellent { color: #28a745; font-weight: bold; }
        .condition-good { color: #5bc0de; }
        .condition-fair { color: #f0ad4e; }
        .condition-poor { color: #d9534f; }
        .condition-critical { color: #a94442; font-weight: bold; }
    </style>
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title">
                                <i class="fa fa-building"></i> Facilities Management
                                <span class="pull-right">
                                    <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addFacilityModal"><i class="fa fa-plus"></i> Add Facility</button>
                                </span>
                            </h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($_SESSION['message'])): ?>
                                <div class="alert alert-success"><?php echo htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?></div>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['error'])): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?></div>
                            <?php endif; ?>
                            
                            <div class="row" style="margin-bottom:20px;">
                                <div class="col-md-12">
                                    <label>Filter by Condition:</label>
                                    <select id="conditionFilter" class="form-control" style="width:200px;display:inline-block;margin-left:10px;">
                                        <option value="">All Conditions</option>
                                        <option value="Excellent">Excellent</option>
                                        <option value="Good">Good</option>
                                        <option value="Fair">Fair</option>
                                        <option value="Poor">Poor</option>
                                        <option value="Critical">Critical</option>
                                    </select>
                                    <label style="margin-left:20px;">Filter by Type:</label>
                                    <select id="typeFilter" class="form-control" style="width:200px;display:inline-block;margin-left:10px;">
                                        <option value="">All Types</option>
                                        <option value="Building">Building</option>
                                        <option value="Classroom">Classroom</option>
                                        <option value="Laboratory">Laboratory</option>
                                        <option value="Library">Library</option>
                                        <option value="Office">Office</option>
                                        <option value="Sports Field">Sports Field</option>
                                        <option value="Playground">Playground</option>
                                        <option value="Cafeteria">Cafeteria</option>
                                        <option value="Dormitory">Dormitory</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                            </div>
                            
                            <table id="facilitiesTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Facility Name</th>
                                        <th>Type</th>
                                        <th>Location</th>
                                        <th>Capacity</th>
                                        <th>Area (m²)</th>
                                        <th>Year Built</th>
                                        <th>Last Renovation</th>
                                        <th>Condition</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($facility = mysqli_fetch_assoc($facilities_result)): 
                                        $condition_class = '';
                                        switch ($facility['condition_status']) {
                                            case 'Excellent': $condition_class = 'condition-excellent'; break;
                                            case 'Good': $condition_class = 'condition-good'; break;
                                            case 'Fair': $condition_class = 'condition-fair'; break;
                                            case 'Poor': $condition_class = 'condition-poor'; break;
                                            case 'Critical': $condition_class = 'condition-critical'; break;
                                        }
                                    ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($facility['facility_name']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($facility['facility_type']); ?></td>
                                        <td><?php echo htmlspecialchars($facility['location'] ?? 'N/A'); ?></td>
                                        <td><?php echo $facility['capacity'] ? number_format($facility['capacity']) : 'N/A'; ?></td>
                                        <td><?php echo $facility['area_sqm'] ? number_format($facility['area_sqm'], 1) : 'N/A'; ?></td>
                                        <td><?php echo $facility['construction_year'] ?? 'N/A'; ?></td>
                                        <td><?php echo $facility['last_renovation'] ? date('d M Y', strtotime($facility['last_renovation'])) : 'N/A'; ?></td>
                                        <td>
                                            <span class="<?php echo $condition_class; ?>">
                                                <?php echo htmlspecialchars($facility['condition_status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="label label-<?php echo $facility['status'] == 1 ? 'success' : 'default'; ?>">
                                                <?php echo $facility['status'] == 1 ? 'Active' : 'Inactive'; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-xs btn-info" onclick='editFacility(<?php echo json_encode($facility); ?>)'>
                                                <i class="fa fa-edit"></i> Edit
                                            </button>
                                            <?php if ($facility['status'] == 1): ?>
                                            <form method="POST" style="display:inline;" onsubmit="return confirm('Deactivate this facility?');">
                                                <input type="hidden" name="action" value="delete">
                                                <input type="hidden" name="facility_id" value="<?php echo $facility['facility_id']; ?>">
                                                <button type="submit" class="btn btn-xs btn-warning"><i class="fa fa-ban"></i> Deactivate</button>
                                            </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
    
    <!-- Add Facility Modal -->
    <div class="modal fade" id="addFacilityModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add Facility</h4>
                </div>
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Facility Name *</label>
                                    <input type="text" name="facility_name" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Facility Type *</label>
                                    <select name="facility_type" class="form-control" required>
                                        <option value="Building">Building</option>
                                        <option value="Classroom">Classroom</option>
                                        <option value="Laboratory">Laboratory</option>
                                        <option value="Library">Library</option>
                                        <option value="Office">Office</option>
                                        <option value="Sports Field">Sports Field</option>
                                        <option value="Playground">Playground</option>
                                        <option value="Cafeteria">Cafeteria</option>
                                        <option value="Dormitory">Dormitory</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Location</label>
                                    <input type="text" name="location" class="form-control" placeholder="e.g., North Wing, Ground Floor">
                                </div>
                                <div class="form-group">
                                    <label>Capacity (persons)</label>
                                    <input type="number" name="capacity" class="form-control" min="0">
                                </div>
                                <div class="form-group">
                                    <label>Area (m²)</label>
                                    <input type="number" name="area_sqm" class="form-control" step="0.01" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Construction Year</label>
                                    <input type="number" name="construction_year" class="form-control" min="1900" max="<?php echo date('Y') + 5; ?>">
                                </div>
                                <div class="form-group">
                                    <label>Last Renovation Date</label>
                                    <input type="date" name="last_renovation" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Condition Status *</label>
                                    <select name="condition_status" class="form-control" required>
                                        <option value="Excellent">Excellent</option>
                                        <option value="Good" selected>Good</option>
                                        <option value="Fair">Fair</option>
                                        <option value="Poor">Poor</option>
                                        <option value="Critical">Critical</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Status *</label>
                                    <select name="status" class="form-control" required>
                                        <option value="1" selected>Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save Facility</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Edit Facility Modal -->
    <div class="modal fade" id="editFacilityModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Edit Facility</h4>
                </div>
                <form method="POST">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" name="facility_id" id="edit_facility_id">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Facility Name *</label>
                                    <input type="text" name="facility_name" id="edit_facility_name" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Facility Type *</label>
                                    <select name="facility_type" id="edit_facility_type" class="form-control" required>
                                        <option value="Building">Building</option>
                                        <option value="Classroom">Classroom</option>
                                        <option value="Laboratory">Laboratory</option>
                                        <option value="Library">Library</option>
                                        <option value="Office">Office</option>
                                        <option value="Sports Field">Sports Field</option>
                                        <option value="Playground">Playground</option>
                                        <option value="Cafeteria">Cafeteria</option>
                                        <option value="Dormitory">Dormitory</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Location</label>
                                    <input type="text" name="location" id="edit_location" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Capacity (persons)</label>
                                    <input type="number" name="capacity" id="edit_capacity" class="form-control" min="0">
                                </div>
                                <div class="form-group">
                                    <label>Area (m²)</label>
                                    <input type="number" name="area_sqm" id="edit_area_sqm" class="form-control" step="0.01" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Construction Year</label>
                                    <input type="number" name="construction_year" id="edit_construction_year" class="form-control" min="1900" max="<?php echo date('Y') + 5; ?>">
                                </div>
                                <div class="form-group">
                                    <label>Last Renovation Date</label>
                                    <input type="date" name="last_renovation" id="edit_last_renovation" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Condition Status *</label>
                                    <select name="condition_status" id="edit_condition_status" class="form-control" required>
                                        <option value="Excellent">Excellent</option>
                                        <option value="Good">Good</option>
                                        <option value="Fair">Fair</option>
                                        <option value="Poor">Poor</option>
                                        <option value="Critical">Critical</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Status *</label>
                                    <select name="status" id="edit_status" class="form-control" required>
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" id="edit_notes" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Update Facility</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
</section>
    <?php include 'includes/footer.php'; ?>
    <!-- Use project's newer jQuery build to avoid conflicts -->
    <script src="js/jquery-1.11.3.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script class="include" type="text/javascript" src="js/jquery.dcjqaccordion.2.7.js"></script>
    <script src="js/jquery.scrollTo.min.js"></script>
    <script src="js/jQuery-slimScroll-1.3.0/jquery.slimscroll.js"></script>
    <script src="js/jquery.nicescroll.js"></script>
    <script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
    <script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
    <script>
        var table;
        $(document).ready(function() {
            table = $('#facilitiesTable').DataTable({
                order: [[0, 'asc']]
            });
            
            $('#conditionFilter').on('change', function() {
                table.column(5).search(this.value).draw();
            });
            
            $('#typeFilter').on('change', function() {
                table.column(1).search(this.value).draw();
            });
        });
        
        function editFacility(facility) {
            try {
                console.log('editFacility called', facility);
                $('#edit_facility_id').val(facility.facility_id);
                $('#edit_facility_name').val(facility.facility_name);
                $('#edit_facility_type').val(facility.facility_type);
                $('#edit_location').val(facility.location);
                $('#edit_capacity').val(facility.capacity);
                $('#edit_area_sqm').val(facility.area_sqm);
                $('#edit_construction_year').val(facility.construction_year);
                $('#edit_last_renovation').val(facility.last_renovation);
                $('#edit_condition_status').val(facility.condition_status);
                $('#edit_status').val(facility.status);
                $('#edit_notes').val(facility.notes);
                // show modal
                $('#editFacilityModal').modal('show');
            } catch (err) {
                // log and alert so we can see what's going wrong in the browser
                console.error('Error in editFacility():', err);
                try { alert('JavaScript error: ' + err.message); } catch(e){}
            }
        }
    </script>
</body>
</html>
