<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Normalize session role level
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canViewFinancialReports($user_level)) {
    header('HTTP/1.1 403 Forbidden');
    echo 'Forbidden';
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// Simple validation: ensure date-like format YYYY-MM-DD
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $start_date)) $start_date = date('Y-m-01');
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $end_date)) $end_date = date('Y-m-d');

// Queries
$income_query = "SELECT COALESCE(SUM(amount_paid), 0) as total FROM accounts_receivable 
               WHERE status IN ('Paid', 'Partial') 
               AND DATE(updated_at) >= '$start_date' AND DATE(updated_at) <= '$end_date'";
$income_result = mysqli_query($con, $income_query);
$income_row = $income_result ? mysqli_fetch_array($income_result) : ['total' => 0];

$expenses_query = "SELECT COALESCE(SUM(amount), 0) as total FROM expenses 
                 WHERE status=1 
                 AND DATE(`date`) >= '$start_date' 
                 AND DATE(`date`) <= '$end_date'";
$expenses_result = mysqli_query($con, $expenses_query);
$expenses_row = $expenses_result ? mysqli_fetch_array($expenses_result) : ['total' => 0];

$payables_query = "SELECT COALESCE(SUM(amount - amount_paid), 0) as total FROM accounts_payable 
                 WHERE status NOT IN ('Paid', 'Cancelled')";
$payables_result = mysqli_query($con, $payables_query);
$payables_row = $payables_result ? mysqli_fetch_array($payables_result) : ['total' => 0];

$receivables_query = "SELECT COALESCE(SUM(amount - amount_paid), 0) as total FROM accounts_receivable 
                    WHERE status NOT IN ('Paid', 'Cancelled')";
$receivables_result = mysqli_query($con, $receivables_query);
$receivables_row = $receivables_result ? mysqli_fetch_array($receivables_result) : ['total' => 0];

// Build CSV
$filename = "financial_report_{$start_date}_to_{$end_date}.csv";
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

$out = fopen('php://output', 'w');
fputcsv($out, ['Report', 'Value']);
fputcsv($out, ['Total Income', number_format($income_row['total'], 2)]);
fputcsv($out, ['Total Expenses', number_format($expenses_row['total'], 2)]);
fputcsv($out, ['Outstanding Payables', number_format($payables_row['total'], 2)]);
fputcsv($out, ['Outstanding Receivables', number_format($receivables_row['total'], 2)]);

// Optionally include raw values in a separate section
fputcsv($out, []);
fputcsv($out, ['Metric', 'Raw Value']);
fputcsv($out, ['income_raw', $income_row['total']]);
fputcsv($out, ['expenses_raw', $expenses_row['total']]);
fputcsv($out, ['payables_raw', $payables_row['total']]);
fputcsv($out, ['receivables_raw', $receivables_row['total']]);

fclose($out);
exit();

?>
