<?php
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
    header('Location:login.php');
    exit;
}
$getstartdate=str_replace('-','/',$_GET['startdate']);
$startdate=  strtotime($getstartdate);
$getenddate=str_replace('-','/',$_GET['enddate']);
$enddate=  strtotime($getenddate);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Expenses from  <?php echo date('d/M/Y',$startdate); ?> to  <?php echo date('d/M/Y',$enddate); ?> </title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                 Expenses from  <?php echo date('d/M/Y',$startdate); ?> to  <?php echo date('d/M/Y',$enddate); ?>
                    </header>
                          <div class="panel-body">
                               <div class="row states-info">
            <div class="col-md-3">
                <div class="panel green-bg">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-4">
                                <i class="fa fa-thumbs-up"></i>
                            </div>
                            <div class="col-xs-8">
                                <span class="state-title">Total Expenses</span>
                                <?php
                                $getexpenses=  mysqli_query($con,"SELECT SUM(amount) as totalexpenses  FROM  expenses WHERE  status=1 AND date>='$startdate' AND date<='$enddate'");
                                $row1= mysqli_fetch_array($getexpenses);
                                $totalexpenses=$row1['totalexpenses'];
                                     ?>
                                <h4><?php echo number_format($totalexpenses); ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
                <a href="expensesreportprint?startdate=<?php echo $startdate;?>&&enddate=<?php echo $enddate; ?>" class="btn btn-primary"  target="_blank">Print Report</a>
            </div>
            </div>
                                              <table  class="display table  table-striped">
        <thead>
        <tr>
              <th>Date</th>
            <th>Expense</th>
            <th> Amount</th>
                           </tr>
        </thead>
        <tbody>
            <?php
         $getexpenses=  mysqli_query($con,"SELECT * FROM  expenses WHERE  status=1 AND date>='$startdate' AND date<='$enddate' ORDER BY date");
            while ($row = mysqli_fetch_array($getexpenses)) {
                $expense_id=$row['expense_id'];
                $expense=$row['expense'];
                $amount=$row['amount'];              
                $date=$row['date'];              
                                     ?>
                <tr class="gradeA">
                    <td><?php echo date('d/M/Y',$date);?></td>
            <td><?php echo $expense;?></td>
            <td><?php echo number_format($amount);?></td>
         
      
                </tr>
            <?php } ?>
        </tbody>
                        </table>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
