<?php
include 'includes/conn.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Allow Super Admin (1), Principal (2), Finance/Admin (3), Finance Manager (8), HR Admin Director (9), Accountant (10)
if ($user_level === 0 || !in_array($user_level, [1,2,3,8,9,10], true)) {
    header('Location:login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Expenses</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-12">
                      <section class="panel">
                    <header class="panel-heading">
                    Expenses
                    </header>
                          <div class="panel-body">
                                              <table  class="display table  table-striped" id="dynamic-table">
        <thead>
        <tr>
              <th>Date</th>
            <th>Expense</th>
            <th> Amount</th>
            <th> &nbsp;</th>
                  </tr>
        </thead>
        <tbody>
            <?php
            $getexpenses = mysqli_query($con, "SELECT * FROM expenses WHERE status=1");
            if (!$getexpenses || mysqli_num_rows($getexpenses) === 0) {
              echo '<tr><td colspan="4" class="text-muted">No expense records found.</td></tr>';
            } else {
            while ($row = mysqli_fetch_assoc($getexpenses)) {
              $expense_id = (int) ($row['expense_id'] ?? 0);
              // Support installations that use `expense` or `description` as the text column
              $expense = $row['expense'] ?? $row['description'] ?? '';
              $amount = $row['amount'] ?? 0;
              $date = $row['date'] ?? '';
                                     ?>
                <tr class="gradeA">
                    <td><?php
                      if (is_numeric($date) && (int)$date > 0) {
                        echo date('d/M/Y', (int)$date);
                      } elseif (is_string($date) && trim($date) !== '') {
                        $dt = DateTime::createFromFormat('Y-m-d', $date);
                        if ($dt !== false) echo $dt->format('d/M/Y');
                        else echo htmlspecialchars($date);
                      } else {
                        echo '';
                      }
                      ?></td>
                <td><?php echo htmlspecialchars($expense);?></td>
                <td><?php echo number_format((float)$amount);?></td>
         
            <td>
                <?php if($user_level === 3){ ?>
                <a href="editexpense?id=<?php echo $expense_id; ?>" class="btn btn-info btn-xs" >Edit</a>
                <a href="removexpense?id=<?php echo $expense_id;?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $expense_id;?>()">Remove</a>
                <?php }?>
            </td>
             <script type="text/javascript">
function confirm_delete<?php echo $expense_id; ?>() {
  return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>    
                </tr>
            <?php } } ?>
        </tbody>
                        </table>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
