<?php
include 'includes/conn.php';
include 'includes/roles.php';

// require elevated permissions to edit contracts
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFullFinancialPermissions($user_level)) {
    header('Location:login.php');
    exit();
}

$contract_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($contract_id <= 0) {
    $_SESSION['message'] = 'Invalid contract id.';
    $_SESSION['msg_type'] = 'danger';
    header('Location: vendorcontracts.php');
    exit();
}

$res = mysqli_query($con, "SELECT * FROM vendor_contracts WHERE contract_id='" . intval($contract_id) . "' LIMIT 1");
if (!$res || mysqli_num_rows($res) === 0) {
    $_SESSION['message'] = 'Contract not found.';
    $_SESSION['msg_type'] = 'warning';
    header('Location: vendorcontracts.php');
    exit();
}

$contract = mysqli_fetch_assoc($res);
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['contract_title'] ?? '');
    $number = trim($_POST['contract_number'] ?? '');
    $start = trim($_POST['start_date'] ?? '');
    $end = trim($_POST['end_date'] ?? '');
    $value = (float)($_POST['total_contract_value'] ?? 0);
    $terms = trim($_POST['contract_terms'] ?? '');
    $reminder = trim($_POST['renewal_reminder_date'] ?? '');
    $status = in_array($_POST['status'] ?? '', ['Draft','Active','Expired','Terminated']) ? $_POST['status'] : 'Draft';

    if ($title === '') {
        $error = 'Title is required.';
    } else {
        $stmt = mysqli_prepare($con, "UPDATE vendor_contracts SET contract_title=?, contract_number=?, start_date=?, end_date=?, total_contract_value=?, contract_terms=?, renewal_reminder_date=?, status=?, updated_at=NOW() WHERE contract_id=?");
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, 'ssssdsssi', $title, $number, $start, $end, $value, $terms, $reminder, $status, $contract_id);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
            $_SESSION['message'] = 'Contract updated successfully.';
            $_SESSION['msg_type'] = 'success';
            header('Location: viewvendorcontract.php?id=' . $contract_id);
            exit();
        } else {
            $error = 'Database error: ' . mysqli_error($con);
        }
    }
}

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Edit Vendor Contract</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<?php include 'includes/header.php'; ?>
<section class="wrapper">
    <div class="row">
        <div class="col-lg-8">
            <section class="panel">
                <header class="panel-heading">Edit Contract</header>
                <div class="panel-body">
                    <?php if ($error) echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>'; ?>
                    <form method="post">
                        <div class="form-group"><label>Contract Title</label><input class="form-control" name="contract_title" required value="<?php echo htmlspecialchars($contract['contract_title']); ?>"></div>
                        <div class="form-group"><label>Contract Number</label><input class="form-control" name="contract_number" value="<?php echo htmlspecialchars($contract['contract_number']); ?>"></div>
                        <div class="form-group"><label>Start Date</label><input class="form-control" name="start_date" type="date" value="<?php echo htmlspecialchars($contract['start_date']); ?>"></div>
                        <div class="form-group"><label>End Date</label><input class="form-control" name="end_date" type="date" value="<?php echo htmlspecialchars($contract['end_date']); ?>"></div>
                        <div class="form-group"><label>Total Value</label><input class="form-control" name="total_contract_value" type="number" step="0.01" value="<?php echo htmlspecialchars($contract['total_contract_value']); ?>"></div>
                        <div class="form-group"><label>Terms</label><textarea class="form-control" name="contract_terms"><?php echo htmlspecialchars($contract['contract_terms']); ?></textarea></div>
                        <div class="form-group"><label>Renewal Reminder Date</label><input class="form-control" name="renewal_reminder_date" type="date" value="<?php echo htmlspecialchars($contract['renewal_reminder_date']); ?>"></div>
                        <div class="form-group"><label>Status</label>
                            <select name="status" class="form-control">
                                <option<?php if($contract['status']=='Draft') echo ' selected'; ?>>Draft</option>
                                <option<?php if($contract['status']=='Active') echo ' selected'; ?>>Active</option>
                                <option<?php if($contract['status']=='Expired') echo ' selected'; ?>>Expired</option>
                                <option<?php if($contract['status']=='Terminated') echo ' selected'; ?>>Terminated</option>
                            </select>
                        </div>
                        <button class="btn btn-primary" type="submit">Save Changes</button>
                        <a href="viewvendorcontract.php?id=<?php echo (int)$contract['contract_id']; ?>" class="btn btn-default">Cancel</a>
                    </form>
                </div>
            </section>
        </div>
    </div>
</section>
</body>
</html>
