<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$vendorId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'vendors'");
if (!$tableCheck || mysqli_num_rows($tableCheck) === 0) {
    die('vendors table not found. Run create_accounting_tables.sql');
}
if ($vendorId <= 0) { header('Location: vendors.php'); exit; }

$message = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = mysqli_real_escape_string($con, $_POST['name'] ?? '');
    $contact_person = mysqli_real_escape_string($con, $_POST['contact_person'] ?? '');
    $email = mysqli_real_escape_string($con, $_POST['email'] ?? '');
    $phone = mysqli_real_escape_string($con, $_POST['phone'] ?? '');
    $address = mysqli_real_escape_string($con, $_POST['address'] ?? '');
    $status = isset($_POST['status']) ? (int)$_POST['status'] : 1;
    $payment_terms = mysqli_real_escape_string($con, $_POST['payment_terms'] ?? '');

    $update = mysqli_query($con, "UPDATE vendors SET
      vendor_name='$name',
        contact_person='$contact_person',
        email='$email',
        phone='$phone',
        address='$address',
        payment_terms='$payment_terms',
        status=$status
        WHERE vendor_id=$vendorId");
    if ($update) {
        $message = 'Vendor updated successfully.';
    } else {
        $error = 'Update failed: '.mysqli_error($con);
    }
}

$vendorQ = mysqli_query($con, "SELECT * FROM vendors WHERE vendor_id=$vendorId LIMIT 1");
$vendor = mysqli_fetch_assoc($vendorQ);
if (!$vendor) { die('Vendor not found'); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Vendor</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-truck"></i> Edit Vendor</h3>
            <a href="vendors.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form class="form-horizontal" method="post">
              <div class="form-group">
                <label class="col-sm-3 control-label">Name</label>
                <div class="col-sm-9"><input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($vendor['vendor_name']); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Contact Person</label>
                <div class="col-sm-9"><input type="text" name="contact_person" class="form-control" value="<?php echo htmlspecialchars($vendor['contact_person']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Email</label>
                <div class="col-sm-9"><input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($vendor['email']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Phone</label>
                <div class="col-sm-9"><input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($vendor['phone']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Address</label>
                <div class="col-sm-9"><textarea name="address" class="form-control" rows="3"><?php echo htmlspecialchars($vendor['address']); ?></textarea></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Payment Terms</label>
                <div class="col-sm-9"><input type="text" name="payment_terms" class="form-control" value="<?php echo htmlspecialchars($vendor['payment_terms']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <option value="1" <?php echo ((int)$vendor['status']===1?'selected':''); ?>>Active</option>
                    <option value="0" <?php echo ((int)$vendor['status']===0?'selected':''); ?>>Inactive</option>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>