<?php
session_start();
include 'includes/conn.php';
include 'includes/roles.php';

$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level) && $user_level !== 2) {
    header('Location: index.php');
    exit;
}

$vehicle_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($vehicle_id <= 0) {
    header('Location: vehicles.php');
    exit;
}

$stmt = mysqli_prepare($con, "SELECT * FROM vehicles WHERE vehicle_id = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, 'i', $vehicle_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$vehicle = mysqli_fetch_assoc($result);

if (!$vehicle) {
    $_SESSION['error'] = 'Vehicle not found';
    header('Location: vehicles.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vehicle_number = mysqli_real_escape_string($con, $_POST['vehicle_number'] ?? '');
    $vehicle_type = mysqli_real_escape_string($con, $_POST['vehicle_type'] ?? 'Bus');
    $make = mysqli_real_escape_string($con, $_POST['make'] ?? '');
    $model = mysqli_real_escape_string($con, $_POST['model'] ?? '');
    $year = !empty($_POST['year']) ? (int) $_POST['year'] : 'NULL';
    $capacity = !empty($_POST['capacity']) ? (int) $_POST['capacity'] : 'NULL';
    $fuel_type = !empty($_POST['fuel_type']) ? "'" . mysqli_real_escape_string($con, $_POST['fuel_type']) . "'" : 'NULL';
    $vin_number = mysqli_real_escape_string($con, $_POST['vin_number'] ?? '');
    $insurance_company = mysqli_real_escape_string($con, $_POST['insurance_company'] ?? '');
    $insurance_policy = mysqli_real_escape_string($con, $_POST['insurance_policy'] ?? '');
    $insurance_expiry = !empty($_POST['insurance_expiry']) ? "'" . mysqli_real_escape_string($con, $_POST['insurance_expiry']) . "'" : 'NULL';
    $license_expiry = !empty($_POST['license_expiry']) ? "'" . mysqli_real_escape_string($con, $_POST['license_expiry']) . "'" : 'NULL';
    $purchase_date = !empty($_POST['purchase_date']) ? "'" . mysqli_real_escape_string($con, $_POST['purchase_date']) . "'" : 'NULL';
    $purchase_cost = !empty($_POST['purchase_cost']) ? (float) $_POST['purchase_cost'] : 'NULL';
    $current_mileage = !empty($_POST['current_mileage']) ? (int) $_POST['current_mileage'] : 0;
    $last_service_date = !empty($_POST['last_service_date']) ? "'" . mysqli_real_escape_string($con, $_POST['last_service_date']) . "'" : 'NULL';
    $next_service_date = !empty($_POST['next_service_date']) ? "'" . mysqli_real_escape_string($con, $_POST['next_service_date']) . "'" : 'NULL';
    $assigned_driver = mysqli_real_escape_string($con, $_POST['assigned_driver'] ?? '');
    $status = mysqli_real_escape_string($con, $_POST['status'] ?? 'Active');
    $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
    
    $update = "UPDATE vehicles SET vehicle_number='$vehicle_number', vehicle_type='$vehicle_type', make='$make', model='$model', 
               year=$year, capacity=$capacity, fuel_type=$fuel_type, vin_number='$vin_number', 
               insurance_company='$insurance_company', insurance_policy='$insurance_policy', insurance_expiry=$insurance_expiry, 
               license_expiry=$license_expiry, purchase_date=$purchase_date, purchase_cost=$purchase_cost, 
               current_mileage=$current_mileage, last_service_date=$last_service_date, next_service_date=$next_service_date,
               assigned_driver='$assigned_driver', status='$status', notes='$notes' 
               WHERE vehicle_id=$vehicle_id";
    
    if (mysqli_query($con, $update)) {
        $_SESSION['message'] = 'Vehicle updated successfully';
        header('Location: vehicles.php');
        exit;
    } else {
        $error = 'Error updating vehicle: ' . mysqli_error($con);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="ThemeBucket">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Edit Vehicle - School Manager</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    
    <section class="wrapper">
        <section class="section">
            <div class="row">
                <div class="col-lg-12">
                    <section class="panel">
                        <header class="panel-heading">
                            <h4 class="panel-title"><i class="fa fa-edit"></i> Edit Vehicle: <?php echo htmlspecialchars($vehicle['vehicle_number']); ?></h4>
                        </header>
                        
                        <div class="panel-body">
                            <?php if (isset($error)): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                            <?php endif; ?>
                            
                            <form method="POST" class="form-horizontal">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>Basic Information</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Vehicle Number *</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="vehicle_number" class="form-control" value="<?php echo htmlspecialchars($vehicle['vehicle_number']); ?>" required>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Vehicle Type *</label>
                                            <div class="col-sm-8">
                                                <select name="vehicle_type" class="form-control" required>
                                                    <option value="Bus" <?php echo $vehicle['vehicle_type'] === 'Bus' ? 'selected' : ''; ?>>Bus</option>
                                                    <option value="Van" <?php echo $vehicle['vehicle_type'] === 'Van' ? 'selected' : ''; ?>>Van</option>
                                                    <option value="Car" <?php echo $vehicle['vehicle_type'] === 'Car' ? 'selected' : ''; ?>>Car</option>
                                                    <option value="Truck" <?php echo $vehicle['vehicle_type'] === 'Truck' ? 'selected' : ''; ?>>Truck</option>
                                                    <option value="Motorcycle" <?php echo $vehicle['vehicle_type'] === 'Motorcycle' ? 'selected' : ''; ?>>Motorcycle</option>
                                                    <option value="Other" <?php echo $vehicle['vehicle_type'] === 'Other' ? 'selected' : ''; ?>>Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Make</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="make" class="form-control" value="<?php echo htmlspecialchars($vehicle['make'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Model</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="model" class="form-control" value="<?php echo htmlspecialchars($vehicle['model'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Year</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="year" class="form-control" min="1900" max="<?php echo date('Y') + 1; ?>" value="<?php echo htmlspecialchars($vehicle['year'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Capacity</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="capacity" class="form-control" min="1" value="<?php echo htmlspecialchars($vehicle['capacity'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Fuel Type</label>
                                            <div class="col-sm-8">
                                                <select name="fuel_type" class="form-control">
                                                    <option value="">Select...</option>
                                                    <option value="Petrol" <?php echo $vehicle['fuel_type'] === 'Petrol' ? 'selected' : ''; ?>>Petrol</option>
                                                    <option value="Diesel" <?php echo $vehicle['fuel_type'] === 'Diesel' ? 'selected' : ''; ?>>Diesel</option>
                                                    <option value="Electric" <?php echo $vehicle['fuel_type'] === 'Electric' ? 'selected' : ''; ?>>Electric</option>
                                                    <option value="Hybrid" <?php echo $vehicle['fuel_type'] === 'Hybrid' ? 'selected' : ''; ?>>Hybrid</option>
                                                    <option value="Other" <?php echo $vehicle['fuel_type'] === 'Other' ? 'selected' : ''; ?>>Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">VIN Number</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="vin_number" class="form-control" value="<?php echo htmlspecialchars($vehicle['vin_number'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <h4>Insurance & Licensing</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Insurance Company</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="insurance_company" class="form-control" value="<?php echo htmlspecialchars($vehicle['insurance_company'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Policy Number</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="insurance_policy" class="form-control" value="<?php echo htmlspecialchars($vehicle['insurance_policy'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Insurance Expiry</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="insurance_expiry" class="form-control" value="<?php echo htmlspecialchars($vehicle['insurance_expiry'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">License Expiry</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="license_expiry" class="form-control" value="<?php echo htmlspecialchars($vehicle['license_expiry'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        
                                        <h4>Purchase & Maintenance</h4>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Purchase Date</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="purchase_date" class="form-control" value="<?php echo htmlspecialchars($vehicle['purchase_date'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Purchase Cost (KES)</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="purchase_cost" class="form-control" step="0.01" min="0" value="<?php echo htmlspecialchars($vehicle['purchase_cost'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Current Mileage (km)</label>
                                            <div class="col-sm-8">
                                                <input type="number" name="current_mileage" class="form-control" min="0" value="<?php echo htmlspecialchars($vehicle['current_mileage'] ?? 0); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Last Service Date</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="last_service_date" class="form-control" value="<?php echo htmlspecialchars($vehicle['last_service_date'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Next Service Date</label>
                                            <div class="col-sm-8">
                                                <input type="date" name="next_service_date" class="form-control" value="<?php echo htmlspecialchars($vehicle['next_service_date'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Assigned Driver</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="assigned_driver" class="form-control" value="<?php echo htmlspecialchars($vehicle['assigned_driver'] ?? ''); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Status</label>
                                            <div class="col-sm-8">
                                                <select name="status" class="form-control">
                                                    <option value="Active" <?php echo $vehicle['status'] === 'Active' ? 'selected' : ''; ?>>Active</option>
                                                    <option value="In Maintenance" <?php echo $vehicle['status'] === 'In Maintenance' ? 'selected' : ''; ?>>In Maintenance</option>
                                                    <option value="Out of Service" <?php echo $vehicle['status'] === 'Out of Service' ? 'selected' : ''; ?>>Out of Service</option>
                                                    <option value="Retired" <?php echo $vehicle['status'] === 'Retired' ? 'selected' : ''; ?>>Retired</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-sm-4 control-label">Notes</label>
                                            <div class="col-sm-8">
                                                <textarea name="notes" class="form-control" rows="3"><?php echo htmlspecialchars($vehicle['notes'] ?? ''); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Update Vehicle</button>
                                        <a href="vehicles.php" class="btn btn-default">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </section>
</section>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>
