<?php
include 'includes/conn.php';
include 'includes/roles.php'; // Include centralized role management
// Only Super Admin may edit users
$isSuperAdmin = (($_SESSION['secusyslevel'] ?? 0) == 1) || (($_SESSION['schoolsyslevel'] ?? 0) == 1);
if (!$isSuperAdmin) {
  header('Location: login');
  exit;
}

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id < 1) {
  header('Location: users.php');
  exit;
}

// Load user data early so POST handling can use current values as defaults
$ustmt = mysqli_prepare($con, "SELECT user_id, staff_id, level, status FROM users WHERE user_id = ? LIMIT 1");
$user = null;
if ($ustmt) {
  mysqli_stmt_bind_param($ustmt, 'i', $id);
  mysqli_stmt_execute($ustmt);
  $ures = mysqli_stmt_get_result($ustmt);
  if ($ures && mysqli_num_rows($ures) > 0) {
    $user = mysqli_fetch_assoc($ures);
  }
  mysqli_stmt_close($ustmt);
}
if (!$user) {
  $_SESSION['msg'] = 'User not found';
  header('Location: users.php');
  exit;
}

// Handle POST update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // use submitted values when present, otherwise keep existing values
  $staff_id = isset($_POST['staff_id']) && $_POST['staff_id'] !== '' ? (int) $_POST['staff_id'] : (int) $user['staff_id'];
  $level = isset($_POST['level']) && $_POST['level'] !== '' ? (int) $_POST['level'] : (int) $user['level'];
  $status = isset($_POST['status']) && $_POST['status'] !== '' ? (int) $_POST['status'] : (int) $user['status'];

  // Basic validation
  $errors = [];
  if (!isValidRole($level)) $errors[] = 'Invalid role selected';
  if ($staff_id < 1) $errors[] = 'Please select a staff record';

  if (empty($errors)) {
    $stmt = mysqli_prepare($con, "UPDATE users SET staff_id = ?, level = ?, status = ? WHERE user_id = ?");
    if ($stmt) {
      // log submitted values for debugging
      $logdir = __DIR__ . DIRECTORY_SEPARATOR . 'logs';
      if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
      $logfile = $logdir . DIRECTORY_SEPARATOR . 'edituser.log';
      $pre = sprintf("[%s] UPDATE user_id=%d submitted: staff_id=%d, level=%d, status=%d\n", date('Y-m-d H:i:s'), $id, $staff_id, $level, $status);
      @file_put_contents($logfile, $pre, FILE_APPEND | LOCK_EX);

      mysqli_stmt_bind_param($stmt, 'iiii', $staff_id, $level, $status, $id);
      $execOk = mysqli_stmt_execute($stmt);
      $affected = mysqli_stmt_affected_rows($stmt);
      if (!$execOk) {
        $dberr = mysqli_error($con);
        @file_put_contents($logfile, "[".date('Y-m-d H:i:s')."] ERROR: execute failed: $dberr\n", FILE_APPEND | LOCK_EX);
      } else {
        @file_put_contents($logfile, "[".date('Y-m-d H:i:s')."] OK: affected_rows={$affected}\n", FILE_APPEND | LOCK_EX);
      }
      mysqli_stmt_close($stmt);
      $_SESSION['msg'] = 'User updated successfully';
      header('Location: users.php');
      exit;
    } else {
      $errors[] = 'Failed to prepare update';
      // log prepare error
      $logdir = __DIR__ . DIRECTORY_SEPARATOR . 'logs';
      if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
      $logfile = $logdir . DIRECTORY_SEPARATOR . 'edituser.log';
      @file_put_contents($logfile, "[".date('Y-m-d H:i:s')."] ERROR: prepare failed: " . mysqli_error($con) . "\n", FILE_APPEND | LOCK_EX);
    }
  }
}

// Load user data
$ustmt = mysqli_prepare($con, "SELECT user_id, staff_id, level, status FROM users WHERE user_id = ? LIMIT 1");
$user = null;
if ($ustmt) {
    mysqli_stmt_bind_param($ustmt, 'i', $id);
    mysqli_stmt_execute($ustmt);
    $ures = mysqli_stmt_get_result($ustmt);
    if ($ures && mysqli_num_rows($ures) > 0) {
        $user = mysqli_fetch_assoc($ures);
    }
    mysqli_stmt_close($ustmt);
}
if (!$user) {
    $_SESSION['msg'] = 'User not found';
    header('Location: users.php');
    exit;
}

// Load staff list for selection
$staffs = mysqli_query($con, "SELECT staff_id, fullname FROM staff WHERE status=1 ORDER BY fullname");

// Get current staff fullname to show as the first selected option
$current_staff_name = '';
if (!empty($user['staff_id'])) {
  $scur = mysqli_query($con, "SELECT fullname FROM staff WHERE staff_id='" . (int)$user['staff_id'] . "' LIMIT 1");
  if ($scur && $srowcur = mysqli_fetch_assoc($scur)) {
    $current_staff_name = $srowcur['fullname'] ?? '';
  }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit User</title>
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body>
<?php include 'includes/header.php'; ?>
<section class="wrapper">
  <div class="row">
    <div class="col-lg-6">
      <section class="panel">
        <header class="panel-heading">Edit User</header>
        <div class="panel-body">
          <?php if (!empty($errors)) {
              foreach ($errors as $e) echo '<div class="alert alert-danger">' . htmlspecialchars($e) . '</div>';
          }
          ?>
          <form method="post" action="">
            <div class="form-group">
              <label>Staff</label>
              <select name="staff_id" class="form-control" required>
                <option value="">Select Staff</option>
                <?php 
                // Reset pointer to beginning of result set
                if ($staffs) {
                  mysqli_data_seek($staffs, 0);
                  while ($s = mysqli_fetch_assoc($staffs)) {
                    $selected = ((int)$s['staff_id'] === (int)$user['staff_id']) ? 'selected' : '';
                    echo '<option value="' . (int)$s['staff_id'] . '" ' . $selected . '>' . htmlspecialchars($s['fullname']) . '</option>';
                  }
                }
                ?>
              </select>
            </div>
            <div class="form-group">
              <label>Role</label>
              <select name="level" class="form-control" required>
                <option value="">Select Role...</option>
                <?php echo generateRoleOptions($user['level']); ?>
              </select>
            </div>
            <div class="form-group">
              <label>Status</label>
              <select name="status" class="form-control">
                <option value="1" <?php echo ($user['status']==1)?'selected':''; ?>>Active</option>
                <option value="0" <?php echo ($user['status']==0)?'selected':''; ?>>Inactive</option>
              </select>
            </div>
            <button class="btn btn-primary" type="submit">Save</button>
            <a href="users.php" class="btn btn-default">Back</a>
          </form>
        </div>
      </section>
    </div>
  </div>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
