<?php
include 'includes/conn.php';
if ((!isset($_SESSION['schoolsys'])) || ($_SESSION['schoolsyslevel'] != 1)) {
  header('Location:login');
}
$id = $_GET['id'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Edit School Term</title>
  <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
  <script src="ckeditor/ckeditor.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/prettyphoto/css/prettyPhoto.css" type="text/css" media="screen" title="prettyPhoto main stylesheet" charset="utf-8" />
  <link href="datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">
              Edit Term
            </header>
            <div class="panel-body">
              <?php
              if (isset($_POST['term'], $_POST['acad_year'])) {
                $term = $_POST['term'];
                // $year = $_POST['year'];
                $notice = $_POST['important_notice'];
                $acad_year = $_POST['acad_year'];
                $startdate =  mysqli_real_escape_string($con, strtotime($_POST['date']));
                $enddate =  mysqli_real_escape_string($con, strtotime($_POST['date2']));
                if (/*empty($year) ||*/ empty($term) || empty($acad_year)) {
                  $errors[] = 'All Fields Are Required';
                }
                if ($startdate > $enddate) {
                  $errors[] = 'Start Date cant be later than End Date';
                }
                if (!empty($errors)) {
                  foreach ($errors as $error) {
              ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                    <div class="alert alert-danger">All Fields are Required</div>
              <?php
                  }
                } else {
                  $sql = "UPDATE `financialterms` SET `term`=?, `academic_year`=?, `important_notice`=?, `startdate`=?, `enddate`=? WHERE `financialterm_id`=?";
                  $ustmt = mysqli_prepare($con, $sql);
                  if ($ustmt) {
                    mysqli_stmt_bind_param($ustmt, 'iisiii', $term, $acad_year, $notice, $startdate, $enddate, $id);
                    mysqli_stmt_execute($ustmt);
                    if (mysqli_stmt_affected_rows($ustmt) >= 0) {
                      echo '<div class="alert alert-success">Term succesfully Edited</div>';
                    } else {
                      echo '<div class="alert alert-danger">Failed to edit term</div>';
                      if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                        echo '<div class="alert alert-danger">DB error: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES) . '</div>';
                      }
                    }
                    mysqli_stmt_close($ustmt);
                  } else {
                    if (isset($_SESSION['schoolsyslevel']) && (int)$_SESSION['schoolsyslevel'] === 1) {
                      echo '<div class="alert alert-danger">DB prepare error: ' . htmlspecialchars(mysqli_error($con), ENT_QUOTES) . '</div>';
                    }
                  }
                }
              }
              $terms =  mysqli_query($con, "SELECT  * FROM financialterms WHERE financialterm_id='$id'");
              $row =  mysqli_fetch_array($terms);
              $term2 = $row['term'];
              $year2 = $row['year'];
              $notice2 = $row['important_notice'];
              $acad_year2 = $row['academic_year'];
              $start = $row['startdate'];
              $end = $row['enddate'];
              ?>

              <form method="post" name='form' class="form-horizontal" action="" enctype="multipart/form-data">
                <div class="hr-line-dashed"></div>
                <div class="form-group"><label class="col-sm-2 control-label">* Term</label>

                  <div class="col-sm-10">
                    <select name="term" class="form-control">
                      <option value="<?php echo $term2; ?>" selected="selected"><?php echo 'Term ' . $term2; ?></option>
                      <option value="1">Term 1</option>
                      <option value="2">Term 2</option>
                      <option value="3">Term 3</option>
                    </select>
                  </div>
                </div>

                <!-- <div class="hr-line-dashed"></div>
                <div class="form-group" id="data_5">
                  <label class="col-sm-2 control-label">*Select Year</label>
                  <div class="col-sm-10">
                    <select name="year" class="form-control">

                      <option value="<?php echo date('Y', $timenow); ?>"><?php echo date('Y', $timenow); ?></option>
                      <?php
                      $datenow = date('Y', $timenow);
                      for ($x = 0; $x <= 15; $x++) {
                        $datenow = $datenow - 1;
                        echo '<option value="' . $datenow . '">' . $datenow . '</option>';
                      }
                      ?>
                    </select>
                  </div>
                </div> -->
                <div class="hr-line-dashed"></div>
                <div class="form-group" id="data_5">
                  <label class="col-sm-2 control-label">*Important Notice</label>
                  <div class="col-sm-10">
                    <textarea name="important_notice" class="form-control" rows="5" placeholder="Enter important notice..."><?php echo $notice2; ?></textarea>
                  </div>
                </div>
                <div class="hr-line-dashed"></div>
                <div class="form-group" id="data_5">
                  <label class="col-sm-2 control-label">*Select Academic Year</label>
                  <div class="col-sm-10">
                    <select name="acad_year" class="form-control">

                      <option value=""></option>
                      <?php
                      $years_aca =  mysqli_query($con, "SELECT  * FROM financialyears WHERE status=1");
                      while ($row =  mysqli_fetch_array($years_aca)) {
                        $fyear_id = $row['fyear_id'];
                        $fyear = $row['fyear'];
                        echo '<option value="' . $fyear_id . '" 
                        ' . (($acad_year2 == $row['fyear_id']) ? 'selected="selected"' : '') . '
                        >' . $fyear . '</option>';
                      }
                      ?>
                    </select>
                  </div>
                </div>
                <div class="hr-line-dashed"></div>

                <div class="form-group" id="data_1">
                  <label class="col-sm-2 control-label">Term Start Date</label>
                  <div class="col-sm-10 input-group date">
                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" value="<?php echo date('m/d/Y', $start); ?>" class="form-control" name="date" placeholder="select date" required="required">
                  </div>
                </div>
                <div class="form-group" id="data_2">
                  <label class="col-sm-2 control-label">Term End Date</label>
                  <div class="col-sm-10 input-group date">
                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" value="<?php echo date('m/d/Y', $end); ?>" class="form-control" name="date2" placeholder="select date" required="required">
                  </div>
                </div>


                <div class="form-group">
                  <div class="col-sm-4 col-sm-offset-2">

                    <button class="btn btn-primary" type="submit">Edit Term</button>
                  </div>
                </div>
              </form>
            </div>

        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>
  <!--body wrapper end-->

  <!--footer section start-->

  <!--footer section end-->


  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="datapicker/bootstrap-datepicker.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  <script>
    $('#data_1 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
    $('#data_2 .input-group.date').datepicker({
      todayBtn: "linked",
      keyboardNavigation: false,
      forceParse: false,
      calendarWeeks: true,
      autoclose: true
    });
    $(document).ready(function() {
      $('#filer_input').filer({
        showThumbs: true,
        addMore: true
      });
    });
    var config = {
      '.chosen-select': {},
      '.chosen-select-deselect': {
        allow_single_deselect: true
      },
      '.chosen-select-no-single': {
        disable_search_threshold: 10
      },
      '.chosen-select-no-results': {
        no_results_text: 'Oops, nothing found!'
      },
      '.chosen-select-width': {
        width: "95%"
      }
    }
    for (var selector in config) {
      $(selector).chosen(config[selector]);
    }
  </script>
</body>

</html>