<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) { header('Location:login.php'); exit; }

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { header('Location: accountspayable.php'); exit; }

$check = mysqli_query($con, "SHOW TABLES LIKE 'payment_schedule'");
if (!$check || mysqli_num_rows($check) === 0) { die('payment_schedule table not found. Run create_accounting_tables.sql'); }

$stmt = mysqli_prepare($con, "SELECT ps.*, ap.invoice_number FROM payment_schedule ps LEFT JOIN accounts_payable ap ON ps.payable_id = ap.payable_id WHERE ps.schedule_id = ? LIMIT 1");
if (!$stmt) { header('Location: paymentschedule.php'); exit; }
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);

if (!$row) { header('Location: paymentschedule.php'); exit; }

// Ensure expected keys exist to avoid PHP 7/8 warnings when rendering
$defaults = [
  'payment_number' => 0,
  'scheduled_date' => '',
  'amount_due' => 0.0,
  'payment_method_id' => 0,
  'amount_paid' => 0.0,
  'payment_date' => '',
  'status' => '',
  'payable_id' => 0,
  'invoice_number' => ''
];
$row = array_merge($defaults, (array)$row);

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $payment_number = (int)($_POST['payment_number'] ?? $row['payment_number']);
  $scheduled_date = mysqli_real_escape_string($con, $_POST['scheduled_date'] ?? $row['scheduled_date']);
  $amount_due = floatval($_POST['amount_due'] ?? $row['amount_due']);
  $payment_method_id = (int)($_POST['payment_method_id'] ?? $row['payment_method_id']);
  $amount_paid = floatval($_POST['amount_paid'] ?? $row['amount_paid']);
  $payment_date = trim($_POST['payment_date'] ?? $row['payment_date']);
  $status = mysqli_real_escape_string($con, $_POST['status'] ?? $row['status']);

  if ($payment_number <= 0) { $error = 'Payment number required.'; }
  elseif ($amount_due <= 0) { $error = 'Amount due must be > 0.'; }
  else {
    // If payment_date is empty, store NULL in the DB to avoid '0000-00-00'
    $use_null_date = ($payment_date === '' || $payment_date === '0000-00-00');

    if ($use_null_date) {
      $upd = mysqli_prepare($con, "UPDATE payment_schedule SET payment_number = ?, scheduled_date = ?, amount_due = ?, payment_method_id = ?, amount_paid = ?, payment_date = NULL, status = ? WHERE schedule_id = ?");
      if ($upd) {
        mysqli_stmt_bind_param($upd, 'isdidsi', $payment_number, $scheduled_date, $amount_due, $payment_method_id, $amount_paid, $status, $id);
        // types: i (payment_number), s (scheduled_date), d (amount_due), i (payment_method_id), d (amount_paid), s (status), i (id)
      }
    } else {
      $payment_date_esc = mysqli_real_escape_string($con, $payment_date);
      $upd = mysqli_prepare($con, "UPDATE payment_schedule SET payment_number = ?, scheduled_date = ?, amount_due = ?, payment_method_id = ?, amount_paid = ?, payment_date = ?, status = ? WHERE schedule_id = ?");
      if ($upd) {
        mysqli_stmt_bind_param($upd, 'isdidssi', $payment_number, $scheduled_date, $amount_due, $payment_method_id, $amount_paid, $payment_date_esc, $status, $id);
        // types: i,s,d,i,d,s,s,i
      }
    }

    if ($upd) {
      if (mysqli_stmt_execute($upd)) {
        mysqli_stmt_close($upd);
        header('Location: paymentschedule.php?payable_id=' . (int)$row['payable_id']);
        exit;
      } else {
        $error = 'Update failed: ' . mysqli_error($con);
      }
      mysqli_stmt_close($upd);
    } else {
      $error = 'Database error: ' . mysqli_error($con);
    }
  }
}

$methods = mysqli_query($con, "SELECT payment_method_id, method_name FROM payment_methods WHERE status=1 ORDER BY method_name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Schedule Entry</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-6 col-lg-offset-3">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-edit"></i> Edit Schedule Entry for <?php echo htmlspecialchars($row['invoice_number'] ?? ''); ?></h3>
            <a href="paymentschedule.php?payable_id=<?php echo (int)$row['payable_id']; ?>" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form method="post" class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label">Payment #</label>
                <div class="col-sm-9"><input type="number" name="payment_number" class="form-control" value="<?php echo (int)$row['payment_number']; ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Scheduled Date</label>
                <div class="col-sm-9"><input type="date" name="scheduled_date" class="form-control" value="<?php echo htmlspecialchars($row['scheduled_date']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Amount Due</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount_due" class="form-control" value="<?php echo number_format($row['amount_due'],2); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Amount Paid</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount_paid" class="form-control" value="<?php echo number_format($row['amount_paid'] ?? 0,2); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Payment Date</label>
                <div class="col-sm-9"><input type="date" name="payment_date" class="form-control" value="<?php echo htmlspecialchars($row['payment_date'] ?? ''); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Method</label>
                <div class="col-sm-9">
                  <select name="payment_method_id" class="form-control">
                    <option value="0">--</option>
                    <?php while ($m = mysqli_fetch_assoc($methods)) { $sel = ((int)$m['payment_method_id'] === (int)$row['payment_method_id']) ? 'selected' : ''; echo '<option value="' . (int)$m['payment_method_id'] . '" ' . $sel . '>' . htmlspecialchars($m['method_name']) . '</option>'; } ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9"><input type="text" name="status" class="form-control" value="<?php echo htmlspecialchars($row['status']); ?>"></div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9"><button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button></div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
