<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
  header('Location: login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: notices.php');
  exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['important_notice'])) {
  $notice = trim($_POST['important_notice']);
  
  $stmt = mysqli_prepare($con, "UPDATE financialterms SET important_notice = ? WHERE financialterm_id = ?");
  if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'si', $notice, $id);
    if (mysqli_stmt_execute($stmt)) {
      $success_message = 'Important notice updated successfully!';
    } else {
      $error_message = 'Failed to update notice. Please try again.';
    }
    mysqli_stmt_close($stmt);
  } else {
    $error_message = 'Database error. Please try again.';
  }
}

// Fetch notice details
$stmt = mysqli_prepare($con, "SELECT financialterm_id, term, year, academic_year, important_notice, status FROM financialterms WHERE financialterm_id = ?");
if ($stmt) {
  mysqli_stmt_bind_param($stmt, 'i', $id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  $row = mysqli_fetch_assoc($result);
  
  if (!$row) {
    header('Location: notices.php');
    exit;
  }
  
  $term = (int)$row['term'];
  $year = $row['year'] ?? '';
  $acad_year = $row['academic_year'] ?? '';
  $notice = $row['important_notice'] ?? '';
  $status = (int)$row['status'];
  
  mysqli_stmt_close($stmt);
} else {
  header('Location: notices.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Important Notice | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>

  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8">
        <section class="panel">
          <header class="panel-heading">
            Edit Important Notice - Term <?php echo $term . ' ' . $acad_year; ?>
          </header>
          <div class="panel-body">
            <?php if (isset($success_message)): ?>
              <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?php echo htmlspecialchars($success_message); ?>
              </div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
              <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?php echo htmlspecialchars($error_message); ?>
              </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Term:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static">Term <?php echo $term; ?></p>
                </div>
              </div>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Academic Year:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo htmlspecialchars($acad_year); ?></p>
                </div>
              </div>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Status:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static">
                    <?php echo $status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-default">Inactive</span>'; ?>
                  </p>
                </div>
              </div>
              
              <hr>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>* Important Notice:</strong></label>
                <div class="col-sm-9">
                  <textarea name="important_notice" class="form-control" rows="10" placeholder="Enter important notice for this term..."><?php echo htmlspecialchars($notice); ?></textarea>
                  <span class="help-block">This notice will appear on progress reports for this term.</span>
                </div>
              </div>
              
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Update Notice</button>
                  <a href="viewnotice.php?id=<?php echo $id; ?>" class="btn btn-default"><i class="fa fa-times"></i> Cancel</a>
                  <a href="notices.php" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back to List</a>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
