<?php
include 'includes/conn.php';
include 'includes/roles.php';

// Authorization
if (!hasFinancialAccess($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    $_SESSION['message'] = 'Invalid fee structure id.';
    $_SESSION['msg_type'] = 'danger';
    header('Location:feestructures.php');
    exit();
}

$fs = null;
// Load existing record (try joins, fallback to simple select)
try {
    $sql = "SELECT fs.*, y.year, t.term, c.class FROM fee_structures fs
            LEFT JOIN academicyears y ON fs.academic_year_id = y.academicyear_id
            LEFT JOIN financialterms t ON fs.term_id = t.financialterm_id
            LEFT JOIN classes c ON fs.class_id = c.class_id
            WHERE fs.fee_structure_id = " . $id . " LIMIT 1";
    $res = mysqli_query($con, $sql);
    if ($res && mysqli_num_rows($res) > 0) $fs = mysqli_fetch_assoc($res);
} catch (mysqli_sql_exception $e) {
    $res = mysqli_query($con, "SELECT * FROM fee_structures WHERE fee_structure_id = " . $id . " LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) $fs = mysqli_fetch_assoc($res);
}

if (!$fs) {
    $_SESSION['message'] = 'Fee structure not found.';
    $_SESSION['msg_type'] = 'danger';
    header('Location:feestructures.php');
    exit();
}

// Handle POST update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $structure_name = mysqli_real_escape_string($con, $_POST['structure_name'] ?? $fs['structure_name']);
    $academic_year_id = (int)($_POST['academic_year_id'] ?? $fs['academic_year_id'] ?? 0);
    $term_id = (int)($_POST['term_id'] ?? $fs['term_id'] ?? 0);
    $class_id = (int)($_POST['class_id'] ?? $fs['class_id'] ?? 0);
    $stream_id = (int)($_POST['stream_id'] ?? $fs['stream_id'] ?? 0);

    $base_tuition = floatval($_POST['base_tuition_fee'] ?? $fs['base_tuition_fee'] ?? 0);
    $boarding = floatval($_POST['boarding_fee'] ?? $fs['boarding_fee'] ?? 0);
    $activity = floatval($_POST['activity_fee'] ?? $fs['activity_fee'] ?? 0);
    $examination = floatval($_POST['examination_fee'] ?? $fs['examination_fee'] ?? 0);
    $technology = floatval($_POST['technology_fee'] ?? $fs['technology_fee'] ?? 0);
    $sports = floatval($_POST['sports_fee'] ?? $fs['sports_fee'] ?? 0);
    $other = floatval($_POST['other_fees'] ?? $fs['other_fees'] ?? 0);
    $total = $base_tuition + $boarding + $activity + $examination + $technology + $sports + $other;

    $description = mysqli_real_escape_string($con, $_POST['description'] ?? $fs['description'] ?? '');
    $status = (int)($_POST['status'] ?? $fs['status'] ?? 0);

    // Perform update
    try {
        $update = "UPDATE fee_structures SET
            structure_name = '" . $structure_name . "',
            academic_year_id = " . $academic_year_id . ",
            term_id = " . $term_id . ",
            class_id = " . $class_id . ",
            stream_id = " . $stream_id . ",
            base_tuition_fee = " . $base_tuition . ",
            boarding_fee = " . $boarding . ",
            activity_fee = " . $activity . ",
            examination_fee = " . $examination . ",
            technology_fee = " . $technology . ",
            sports_fee = " . $sports . ",
            other_fees = " . $other . ",
            total_fee = " . $total . ",
            description = '" . $description . "',
            status = " . $status . ",
            updated_at = NOW()
            WHERE fee_structure_id = " . $id;

        mysqli_query($con, $update);
        $_SESSION['message'] = 'Fee structure updated successfully.';
        $_SESSION['msg_type'] = 'success';
        header('Location:feestructures.php');
        exit();
    } catch (mysqli_sql_exception $e) {
        $_SESSION['message'] = 'Database error: ' . $e->getMessage();
        $_SESSION['msg_type'] = 'danger';
    }
}

// Load reference lists (best-effort, ignore errors). Use try/catch because mysqli may throw exceptions when tables are missing.
$years = false; $terms = false; $classes = false;
try {
    $years = mysqli_query($con, "SELECT academicyear_id, year FROM academicyears ORDER BY academicyear_id DESC");
} catch (mysqli_sql_exception $e) {
    $years = false;
}
try {
    $terms = mysqli_query($con, "SELECT financialterm_id, term FROM financialterms ORDER BY financialterm_id DESC");
} catch (mysqli_sql_exception $e) {
    $terms = false;
}
try {
    $classes = mysqli_query($con, "SELECT class_id, class FROM classes ORDER BY class_id DESC");
} catch (mysqli_sql_exception $e) {
    $classes = false;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Edit Fee Structure</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
    <link href="css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-8 col-lg-offset-2">
                <section class="panel">
                    <header class="panel-heading"><h4 class="panel-title">Edit Fee Structure</h4></header>
                    <div class="panel-body">
                        <?php if (isset($_SESSION['message'])) { echo '<div class="alert alert-'.($_SESSION['msg_type'] ?? 'info').'">'.htmlspecialchars($_SESSION['message']).'</div>'; unset($_SESSION['message']); unset($_SESSION['msg_type']); } ?>
                        <form method="post" action="">
                            <div class="form-group">
                                <label>Structure Name</label>
                                <input type="text" name="structure_name" class="form-control" value="<?php echo htmlspecialchars($fs['structure_name'] ?? ''); ?>" required>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4">
                                    <label>Academic Year</label>
                                    <select name="academic_year_id" class="form-control">
                                        <option value="0">-</option>
                                        <?php if ($years) { while($y = mysqli_fetch_assoc($years)) { echo '<option value="'.(int)$y['academicyear_id'].'"'.(((int)$fs['academic_year_id'])==((int)$y['academicyear_id']) ? ' selected' : '').'>'.htmlspecialchars($y['year']).'</option>'; } } ?>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label>Term</label>
                                    <select name="term_id" class="form-control">
                                        <option value="0">-</option>
                                        <?php if ($terms) { while($t = mysqli_fetch_assoc($terms)) { echo '<option value="'.(int)$t['financialterm_id'].'"'.(((int)$fs['term_id'])==((int)$t['financialterm_id']) ? ' selected' : '').'>'.htmlspecialchars($t['term']).'</option>'; } } ?>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label>Class</label>
                                    <select name="class_id" class="form-control">
                                        <option value="0">-</option>
                                        <?php if ($classes) { while($c = mysqli_fetch_assoc($classes)) { echo '<option value="'.(int)$c['class_id'].'"'.(((int)$fs['class_id'])==((int)$c['class_id']) ? ' selected' : '').'>'.htmlspecialchars($c['class']).'</option>'; } } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6"><label>Base Tuition Fee</label><input name="base_tuition_fee" class="form-control" value="<?php echo htmlspecialchars($fs['base_tuition_fee'] ?? '0.00'); ?>"></div>
                                <div class="form-group col-md-6"><label>Boarding Fee</label><input name="boarding_fee" class="form-control" value="<?php echo htmlspecialchars($fs['boarding_fee'] ?? '0.00'); ?>"></div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4"><label>Activity Fee</label><input name="activity_fee" class="form-control" value="<?php echo htmlspecialchars($fs['activity_fee'] ?? '0.00'); ?>"></div>
                                <div class="form-group col-md-4"><label>Examination Fee</label><input name="examination_fee" class="form-control" value="<?php echo htmlspecialchars($fs['examination_fee'] ?? '0.00'); ?>"></div>
                                <div class="form-group col-md-4"><label>Technology Fee</label><input name="technology_fee" class="form-control" value="<?php echo htmlspecialchars($fs['technology_fee'] ?? '0.00'); ?>"></div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4"><label>Sports Fee</label><input name="sports_fee" class="form-control" value="<?php echo htmlspecialchars($fs['sports_fee'] ?? '0.00'); ?>"></div>
                                <div class="form-group col-md-4"><label>Other Fees</label><input name="other_fees" class="form-control" value="<?php echo htmlspecialchars($fs['other_fees'] ?? '0.00'); ?>"></div>
                                <div class="form-group col-md-4"><label>Status</label><select name="status" class="form-control"><option value="1"<?php echo ((isset($fs['status']) && $fs['status']==1)?' selected':''); ?>>Active</option><option value="0"<?php echo ((isset($fs['status']) && $fs['status']==0)?' selected':''); ?>>Inactive</option></select></div>
                            </div>

                            <div class="form-group"><label>Description</label><textarea name="description" class="form-control" rows="4"><?php echo htmlspecialchars($fs['description'] ?? ''); ?></textarea></div>

                            <div class="form-group">
                                <button class="btn btn-primary" type="submit">Save Changes</button>
                                <a href="feestructures.php" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
