<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canManageBudgets($user_level)) {
  header('Location:login.php');
  exit;
}

$budget_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($budget_id <= 0) { header('Location: budgets.php'); exit; }

// ensure table exists
$check = mysqli_query($con, "SHOW TABLES LIKE 'budgets'");
if (!$check || mysqli_num_rows($check) === 0) { die('budgets table not found.'); }

// fetch budget
$stmt = mysqli_prepare($con, "SELECT * FROM budgets WHERE budget_id = ? LIMIT 1");
if (!$stmt) { header('Location: budgets.php'); exit; }
mysqli_stmt_bind_param($stmt,'i',$budget_id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$budget = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);
if (!$budget) { header('Location: budgets.php'); exit; }

// defaults guard
$defaults = [
  'budget_id'=>0,'budget_name'=>'','department'=>'','fiscal_year'=>'','budget_period'=>'',
  'total_budget'=>0.0,'allocated_amount'=>0.0,'spent_amount'=>0.0,'remaining_amount'=>0.0,
  'status'=>''
];
$budget = array_merge($defaults,(array)$budget);

$message = '';
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $bn = trim($_POST['budget_name'] ?? $budget['budget_name']);
  $dept = trim($_POST['department'] ?? $budget['department']);
  $fy = trim($_POST['fiscal_year'] ?? $budget['fiscal_year']);
  $period = trim($_POST['budget_period'] ?? $budget['budget_period']);
  $total_raw = trim($_POST['total_budget'] ?? $budget['total_budget']);
  $total = is_numeric(str_replace([',',' '],['',''],$total_raw)) ? (float)str_replace([',',' '],['',''],$total_raw) : null;
  $allocated = is_numeric(str_replace([',',' '],['',''],$_POST['allocated_amount'] ?? $budget['allocated_amount'])) ? (float)str_replace([',',' '],['',''],$_POST['allocated_amount'] ?? $budget['allocated_amount']) : 0.0;
  $spent = is_numeric(str_replace([',',' '],['',''],$_POST['spent_amount'] ?? $budget['spent_amount'])) ? (float)str_replace([',',' '],['',''],$_POST['spent_amount'] ?? $budget['spent_amount']) : 0.0;
  $remaining = is_numeric(str_replace([',',' '],['',''],$_POST['remaining_amount'] ?? $budget['remaining_amount'])) ? (float)str_replace([',',' '],['',''],$_POST['remaining_amount'] ?? $budget['remaining_amount']) : 0.0;
  $status = trim($_POST['status'] ?? $budget['status']);

  if ($bn === '' || $total === null) {
    $error = 'Budget name and total budget are required and total must be numeric.';
  } else {
    try {
      $upd = mysqli_prepare($con, "UPDATE budgets SET budget_name=?, department=?, fiscal_year=?, budget_period=?, total_budget=?, allocated_amount=?, spent_amount=?, remaining_amount=?, status=?, updated_at=CURRENT_TIMESTAMP WHERE budget_id=?");
      if (!$upd) throw new Exception(mysqli_error($con));
      mysqli_stmt_bind_param($upd,'ssssddddsi',$bn,$dept,$fy,$period,$total,$allocated,$spent,$remaining,$status,$budget_id);
      if (mysqli_stmt_execute($upd)) {
        mysqli_stmt_close($upd);
        $_SESSION['message'] = 'Budget updated successfully.';
        $_SESSION['msg_type'] = 'success';
        header('Location: budgets.php');
        exit;
      } else {
        $error = 'Update failed: ' . mysqli_error($con);
      }
    } catch (Exception $ex) {
      error_log('Budget update error: ' . $ex->getMessage());
      $error = 'Database error while updating budget.';
    }
  }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Budget</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">Edit Budget</header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form method="post" class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label">Budget Name</label>
                <div class="col-sm-9"><input type="text" name="budget_name" class="form-control" value="<?php echo htmlspecialchars($budget['budget_name']); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Department</label>
                <div class="col-sm-9"><input type="text" name="department" class="form-control" value="<?php echo htmlspecialchars($budget['department']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Fiscal Year</label>
                <div class="col-sm-9"><input type="text" name="fiscal_year" class="form-control" value="<?php echo htmlspecialchars($budget['fiscal_year']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Budget Period</label>
                <div class="col-sm-9"><input type="text" name="budget_period" class="form-control" value="<?php echo htmlspecialchars($budget['budget_period']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Total Budget</label>
                <div class="col-sm-9"><input type="text" name="total_budget" class="form-control" value="<?php echo number_format($budget['total_budget'],2); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Allocated Amount</label>
                <div class="col-sm-9"><input type="text" name="allocated_amount" class="form-control" value="<?php echo number_format($budget['allocated_amount'],2); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Spent Amount</label>
                <div class="col-sm-9"><input type="text" name="spent_amount" class="form-control" value="<?php echo number_format($budget['spent_amount'],2); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Remaining Amount</label>
                <div class="col-sm-9"><input type="text" name="remaining_amount" class="form-control" value="<?php echo number_format($budget['remaining_amount'],2); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9"><input type="text" name="status" class="form-control" value="<?php echo htmlspecialchars($budget['status']); ?>"></div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9"><button type="submit" class="btn btn-primary">Save</button> <a href="budgets.php" class="btn btn-default">Cancel</a></div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>