<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$accountId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Ensure table exists
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'bank_accounts'");
if (!$tableCheck || mysqli_num_rows($tableCheck) === 0) {
    die('bank_accounts table not found. Run create_accounting_tables.sql');
}

if ($accountId <= 0) {
    header('Location: bankaccounts.php');
    exit;
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank_name = mysqli_real_escape_string($con, $_POST['bank_name'] ?? '');
    $account_number = mysqli_real_escape_string($con, $_POST['account_number'] ?? '');
    $account_holder = mysqli_real_escape_string($con, $_POST['account_holder'] ?? '');
    $branch = mysqli_real_escape_string($con, $_POST['branch'] ?? '');
    $currency = mysqli_real_escape_string($con, $_POST['currency'] ?? 'KES');
    $account_type = mysqli_real_escape_string($con, $_POST['account_type'] ?? 'Current');
    $balance = floatval($_POST['balance'] ?? 0);
    $status = isset($_POST['status']) ? (int)$_POST['status'] : 1;

    $update = mysqli_query($con, "UPDATE bank_accounts SET 
        bank_name='$bank_name',
        account_number='$account_number',
        account_holder='$account_holder',
        branch='$branch',
        currency='$currency',
        account_type='$account_type',
        balance=$balance,
        status=$status
        WHERE bank_account_id=$accountId");

    if ($update) {
        $message = 'Bank account updated successfully.';
    } else {
        $error = 'Update failed: '.mysqli_error($con);
    }
}

$accountQ = mysqli_query($con, "SELECT * FROM bank_accounts WHERE bank_account_id=$accountId LIMIT 1");
$account = mysqli_fetch_assoc($accountQ);
if (!$account) { die('Bank account not found'); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Bank Account</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-building-o"></i> Edit Bank Account</h3>
            <a href="bankaccounts.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form class="form-horizontal" method="post">
              <div class="form-group">
                <label class="col-sm-3 control-label">Bank Name</label>
                <div class="col-sm-9"><input type="text" name="bank_name" class="form-control" value="<?php echo htmlspecialchars($account['bank_name']); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Account Number</label>
                <div class="col-sm-9"><input type="text" name="account_number" class="form-control" value="<?php echo htmlspecialchars($account['account_number']); ?>" required></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Account Holder</label>
                <div class="col-sm-9"><input type="text" name="account_holder" class="form-control" value="<?php echo htmlspecialchars($account['account_holder']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Branch</label>
                <div class="col-sm-9"><input type="text" name="branch" class="form-control" value="<?php echo htmlspecialchars($account['branch']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Currency</label>
                <div class="col-sm-9"><input type="text" name="currency" class="form-control" value="<?php echo htmlspecialchars($account['currency']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Account Type</label>
                <div class="col-sm-9">
                  <select name="account_type" class="form-control">
                    <?php
                      $types = ['Current','Savings','Investment'];
                      foreach ($types as $t) {
                        $sel = ($account['account_type']===$t)?'selected':'';
                        echo "<option value='$t' $sel>$t</option>";
                      }
                    ?>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Balance</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="balance" class="form-control" value="<?php echo htmlspecialchars($account['balance']); ?>"></div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <option value="1" <?php echo ((int)$account['status']===1?'selected':''); ?>>Active</option>
                    <option value="0" <?php echo ((int)$account['status']===0?'selected':''); ?>>Inactive</option>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>