<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFinancialAccess($user_level)) { header('Location:login.php'); exit; }

$payableId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($payableId <= 0) { header('Location: accountspayable.php'); exit; }

$check = mysqli_query($con, "SHOW TABLES LIKE 'accounts_payable'");
if (!$check || mysqli_num_rows($check) === 0) { die('accounts_payable table not found. Run create_accounting_tables.sql'); }

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vendor_id = (int)($_POST['vendor_id'] ?? 0);
    $invoice_number = mysqli_real_escape_string($con, $_POST['invoice_number'] ?? '');
    $invoice_date = mysqli_real_escape_string($con, $_POST['invoice_date'] ?? date('Y-m-d'));
    $due_date = mysqli_real_escape_string($con, $_POST['due_date'] ?? date('Y-m-d'));
    $amount = floatval($_POST['amount'] ?? 0);
    $amount_paid = floatval($_POST['amount_paid'] ?? 0);
    $status = mysqli_real_escape_string($con, $_POST['status'] ?? 'Draft');
    $description = mysqli_real_escape_string($con, $_POST['description'] ?? '');
    $payment_terms = mysqli_real_escape_string($con, $_POST['payment_terms'] ?? '');

    if ($vendor_id <= 0) { $error = 'Select a vendor.'; }
    elseif ($amount <= 0) { $error = 'Amount must be greater than zero.'; }
    else {
        $update_q = "UPDATE accounts_payable SET vendor_id=$vendor_id, invoice_number='$invoice_number', invoice_date='$invoice_date', due_date='$due_date', amount=$amount, amount_paid=$amount_paid, status='$status', description='$description', payment_terms='$payment_terms' WHERE payable_id=$payableId";
        if (mysqli_query($con, $update_q)) {
            $message = 'Invoice updated successfully.';
            header('Location: accountspayable.php?msg=updated');
            exit;
        } else {
            $error = 'Update failed: ' . mysqli_error($con);
        }
    }
}

$payableQ = mysqli_query($con, "SELECT * FROM accounts_payable WHERE payable_id=$payableId LIMIT 1");
$payable = mysqli_fetch_assoc($payableQ);
if (!$payable) { header('Location: accountspayable.php'); exit; }

$vendors = mysqli_query($con, "SELECT vendor_id, vendor_name AS name FROM vendors WHERE status=1 ORDER BY vendor_name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Accounts Payable</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-edit"></i> Edit Vendor Invoice</h3>
            <a href="accountspayable.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?><div class="alert alert-success"><?php echo $message; ?></div><?php endif; ?>
            <?php if ($error): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>
            <form method="post" class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label">Vendor</label>
                <div class="col-sm-9">
                  <select name="vendor_id" class="form-control" required>
                    <option value="">-- Select Vendor --</option>
                    <?php while ($v = mysqli_fetch_assoc($vendors)) {
                      $sel = ((int)$v['vendor_id'] === (int)($payable['vendor_id'] ?? 0)) ? 'selected' : '';
                      echo "<option value='{$v['vendor_id']}' $sel>" . htmlspecialchars($v['name']) . "</option>";
                    } ?>
                  </select>
                </div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Invoice #</label>
                <div class="col-sm-9"><input type="text" name="invoice_number" class="form-control" value="<?php echo htmlspecialchars($payable['invoice_number']); ?>" required></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Invoice Date</label>
                <div class="col-sm-9"><input type="date" name="invoice_date" class="form-control" value="<?php echo htmlspecialchars($payable['invoice_date']); ?>"></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Due Date</label>
                <div class="col-sm-9"><input type="date" name="due_date" class="form-control" value="<?php echo htmlspecialchars($payable['due_date']); ?>"></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Amount</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount" class="form-control" value="<?php echo number_format($payable['amount'],2); ?>" required></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Amount Paid</label>
                <div class="col-sm-9"><input type="number" step="0.01" name="amount_paid" class="form-control" value="<?php echo number_format($payable['amount_paid'] ?? 0,2); ?>"></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <?php foreach (['Draft','Pending','Approved','Paid','Cancelled'] as $s) { $sel = ($payable['status']==$s?'selected':''); echo "<option value='$s' $sel>$s</option>"; } ?>
                  </select>
                </div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Payment Terms</label>
                <div class="col-sm-9"><input type="text" name="payment_terms" class="form-control" value="<?php echo htmlspecialchars($payable['payment_terms'] ?? ''); ?>"></div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label">Description</label>
                <div class="col-sm-9"><textarea name="description" class="form-control" rows="3"><?php echo htmlspecialchars($payable['description']); ?></textarea></div>
              </div>

              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9"><button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button></div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
