<?php
include 'includes/conn.php';
if(session_status()!==PHP_SESSION_ACTIVE) session_start();
if(!isset($_SESSION['schoolsyslevel']) || ($_SESSION['schoolsyslevel']!=6)){
  header('Location:login');
  exit;
}
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($id<=0){
  header('Location:students.php');
  exit;
}
// Fetch existing student record safely
$student = null;
$stmt = mysqli_prepare($con, "SELECT * FROM students WHERE status=1 AND student_id=?");
if($stmt){
  mysqli_stmt_bind_param($stmt,'i',$id);
  mysqli_stmt_execute($stmt);
  $res = mysqli_stmt_get_result($stmt);
  $student = mysqli_fetch_array($res);
  mysqli_stmt_close($stmt);
} else {
  // fallback
  $res = mysqli_query($con, "SELECT * FROM students WHERE status=1 AND student_id='".(int)$id."'");
  $student = mysqli_fetch_array($res);
}
if(!$student){
  echo '<div class="alert alert-danger">Student not found</div>';
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Edit Student</title>  
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/ckeditor/ckeditor.js"></script>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; 
//   echo str_replace('\', ' ',$organisation);
   ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
            <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                 Edit  Student
                    </header>
                    <div class="panel-body">
                   <?php
   if(isset($_POST['fullname'],$_POST['nationality'],$_POST['gender'],$_POST['class'],$_POST['year'],$_POST['term'],$_POST['birthday'],$_POST['regnumber'],$_POST['number'])){
    $image_name = isset($_FILES['image']['name']) ? $_FILES['image']['name'] : '';
    $image_size = isset($_FILES['image']['size']) ? $_FILES['image']['size'] : 0;
    $image_temp = isset($_FILES['image']['tmp_name']) ? $_FILES['image']['tmp_name'] : '';
    $allowed_ext = array('jpg','jpeg','png','gif','bmp');
    $imgext = explode('.',$image_name);
    $imgext2 = end($imgext);
    $image_ext = strtolower($imgext2);

    $fullname = trim($_POST['fullname']);
    $nationality = trim($_POST['nationality']);
    $regnumber = trim($_POST['regnumber']);
    $birthday_ts = !empty($_POST['birthday']) ? strtotime($_POST['birthday']) : 0;
    $gender = trim($_POST['gender']);
    $class = trim($_POST['class']);
    $year = (int)$_POST['year'];
    $term = (int)$_POST['term'];
    $number = trim($_POST['number']);
    $fathername = trim($_POST['fathername'] ?? '');
    $fatheroccupation = trim($_POST['fatheroccupation'] ?? '');
    $fatheremail = trim($_POST['fatheremail'] ?? '');
    $fatherphone = trim($_POST['fatherphone'] ?? '');
    $mothername = trim($_POST['mothername'] ?? '');
    $motheroccupation = trim($_POST['motheroccupation'] ?? '');
    $motheremail = trim($_POST['motheremail'] ?? '');
    $motherphone = trim($_POST['motherphone'] ?? '');

    // basic validations
    $errors = array();
    if(!empty($regnumber)){
      $chk_stmt = mysqli_prepare($con, "SELECT student_id FROM students WHERE regnumber=? AND status=1 AND student_id!=?");
      if($chk_stmt){
        mysqli_stmt_bind_param($chk_stmt,'si',$regnumber,$id);
        mysqli_stmt_execute($chk_stmt);
        mysqli_stmt_store_result($chk_stmt);
        if(mysqli_stmt_num_rows($chk_stmt)>0) $errors[] = 'Student Number already Exists';
        mysqli_stmt_close($chk_stmt);
      } else {
        $checkreg = mysqli_query($con, "SELECT student_id FROM students WHERE regnumber='".mysqli_real_escape_string($con,$regnumber)."' AND status=1 AND student_id!='".(int)$id."'");
        if(mysqli_num_rows($checkreg)>0) $errors[] = 'Student Number already Exists';
      }
    }
    if(!empty($image_name)){
      if(!in_array($image_ext,$allowed_ext)) $errors[] = 'Image File type not allowed';
      if($image_size>5097152) $errors[] = 'Maximum Image size is 5Mb';
    }
    if(empty($class)) $errors[] = 'class Not Selected';
    if(empty($year)) $errors[] = 'Year Not Selected';
    if(empty($term)) $errors[] = 'Term Not Selected';
    if(empty($gender)) $errors[] = 'Gender Not Selected';

    if(!empty($errors)){
      foreach($errors as $error){
        echo '<div class="alert alert-danger">'.htmlspecialchars($error,ENT_QUOTES).'</div>';
      }
    } else {
      include 'includes/thumbs3.php';
      $split = explode('_',$class);
      $class_id = (int) current($split);
      $stream_id = (int) end($split);

      // determine ext to store: existing or new
      $ext_to_store = $student['ext'] ?? '';
      if(!empty($image_name)) $ext_to_store = $image_ext;

      $update_sql = "UPDATE students SET regnumber=?,fullname=?,gender=?,ext=?,joiningyear=?,joiningterm=?,birthday=?,nationality=?,class_id=?,stream_id=?,number=?,fathername=?,fatheroccupation=?,fatheremail=?,fatherphone=?,mothername=?,motheroccupation=?,motheremail=?,motherphone=? WHERE student_id=?";
      $stmtu = mysqli_prepare($con,$update_sql);
      if($stmtu){
        mysqli_stmt_bind_param($stmtu,'ssssiiisiisssssssssi', $regnumber, $fullname, $gender, $ext_to_store, $year, $term, $birthday_ts, $nationality, $class_id, $stream_id, $number, $fathername, $fatheroccupation, $fatheremail, $fatherphone, $mothername, $motheroccupation, $motheremail, $motherphone, $id);
        mysqli_stmt_execute($stmtu);
        mysqli_stmt_close($stmtu);
      } else {
        // fallback to escaped query
        $safe_sql = "UPDATE students SET regnumber='".mysqli_real_escape_string($con,$regnumber)."',fullname='".mysqli_real_escape_string($con,$fullname)."',gender='".mysqli_real_escape_string($con,$gender)."',ext='".mysqli_real_escape_string($con,$ext_to_store)."',joiningyear='".(int)$year."',joiningterm='".(int)$term."',birthday='".(int)$birthday_ts."',nationality='".mysqli_real_escape_string($con,$nationality)."',class_id='".(int)$class_id."',stream_id='".(int)$stream_id."',number='".mysqli_real_escape_string($con,$number)."',fathername='".mysqli_real_escape_string($con,$fathername)."',fatheroccupation='".mysqli_real_escape_string($con,$fatheroccupation)."',fatheremail='".mysqli_real_escape_string($con,$fatheremail)."',fatherphone='".mysqli_real_escape_string($con,$fatherphone)."',mothername='".mysqli_real_escape_string($con,$mothername)."',motheroccupation='".mysqli_real_escape_string($con,$motheroccupation)."',motheremail='".mysqli_real_escape_string($con,$motheremail)."',motherphone='".mysqli_real_escape_string($con,$motherphone)."' WHERE student_id='".(int)$id."'";
        mysqli_query($con,$safe_sql);
      }

      if(!empty($image_name) && !empty($image_temp)){
        $image_file = md5($id).'.'.$image_ext;
        if(move_uploaded_file($image_temp, 'images/students/'.$image_file)){
          create_thumb('images/students/',$image_file,'images/students/thumbs/');
        }
      }

      echo '<div class="alert alert-success">Student Data succesfully Edited</div>';
      // refresh fetched student data
      $student = null;
      $stmtx = mysqli_prepare($con, "SELECT * FROM students WHERE status=1 AND student_id=?");
      if($stmtx){
        mysqli_stmt_bind_param($stmtx,'i',$id);
        mysqli_stmt_execute($stmtx);
        $resx = mysqli_stmt_get_result($stmtx);
        $student = mysqli_fetch_array($resx);
        mysqli_stmt_close($stmtx);
      }
    }
  }
// (previous invoice code removed) 
                                        // populate form values from $student fetched earlier
                                        $regnumber = $student['regnumber'] ?? '';
                                        $student_id = $student['student_id'] ?? '';
                                        $fullname = $student['fullname'] ?? '';
                                        $gender = $student['gender'] ?? '';
                                        $number = $student['number'] ?? '';
                                        $class_id = $student['class_id'] ?? 0;
                                        $stream_id = $student['stream_id'] ?? 0;
                                        $nationality = $student['nationality'] ?? '';
                                        $birthday = $student['birthday'] ?? 0;
                                        $fathername = $student['fathername'] ?? '';
                                        $year = $student['joiningyear'] ?? '';
                                        $term = $student['joiningterm'] ?? '';
                                        $fatheroccupation = $student['fatheroccupation'] ?? '';
                                        $fatheremail = $student['fatheremail'] ?? '';
                                        $fatherphone = $student['fatherphone'] ?? '';
                                        $mothername = $student['mothername'] ?? '';
                                        $motheroccupation = $student['motheroccupation'] ?? '';
                                        $motheremail = $student['motheremail'] ?? '';
                                        $motherphone = $student['motherphone'] ?? '';
                                        $status = $student['status'] ?? '';
                                        $ext = $student['ext'] ?? '';
                                        $class = '';
                                        $stream = '';
                                        if ($class_id > 0) {
                                            $getclass = mysqli_query($con,"SELECT * FROM classes WHERE class_id='".(int)$class_id."'");
                                            if ($getclass) {
                                                $row2 = mysqli_fetch_array($getclass);
                                                if ($row2) {
                                                    $class = $row2['class'] ?? '';
                                                }
                                            }
                                        }
                                        if ($stream_id > 0) {
                                            $getstream = mysqli_query($con,"SELECT * FROM streams WHERE stream_id='".(int)$stream_id."'");
                                            if ($getstream) {
                                                $roww = mysqli_fetch_array($getstream);
                                                if ($roww) {
                                                    $stream = $roww['stream'] ?? '';
                                                }
                                            }
                                        }
                                    ?>                        
     <form method="post" name='form' class="form" action=""  enctype="multipart/form-data">         
                                <div class="form-group"><label class="control-label">* Full name</label>
                                    <input type="text" name='fullname' class="form-control" placeholder="Enter full Name" required="required" value="<?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>">
                                                                                                            </div>                             
                                  <div class="form-group"><label class="control-label">* Gender</label>
                                        <select name="gender" class="form-control">
                                            <option value="<?php echo htmlspecialchars($gender, ENT_QUOTES); ?>" selected="selected"><?php echo htmlspecialchars($gender, ENT_QUOTES);?></option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                        </select>
                                  </div>
                                 <div class="hr-line-dashed"></div>
                                  <div class="form-group"><label class="control-label">* Class</label>
                                        <select name="class" class="form-control">
                                                     <option value="<?php echo $class_id.'_'.$stream_id; ?>" selected="selected"><?php echo $class.' '.$stream;?></option>
                                     <?php
                                   $getclass=  mysqli_query($con,"SELECT * FROM classes");
                                   if ($getclass) {
                                       while($row2=  mysqli_fetch_array($getclass)){
                                         if ($row2) {
                                             $classname=$row2['class'];
                                             $class_id_loop=$row2['class_id'];
                                             $getstreams=mysqli_query($con,"SELECT * FROM streams WHERE class_id='$class_id_loop'");
                                             if($getstreams && mysqli_num_rows($getstreams)>0){
                                                 while ($row = mysqli_fetch_array($getstreams)) {
                                                     if ($row) {
                                                         $stream_id_loop=$row['stream_id'];
                                                         $stream_loop=$row['stream'];    
                            ?>
                                            <option value="<?php echo $class_id_loop.'_'.$stream_id_loop;?>"><?php echo $classname.' '.$stream_loop; ?></option>
                            <?php 
                                                     }
                                                 }
                                             } else { ?>
                                        <option value="<?php echo $class_id_loop.'_0';?>"><?php echo $classname; ?></option>
                                   <?php    
                                             }
                                         }
                                       }
                                   } ?>
                                                                                 </select>
                                                                                                     </div>
                                <div class="hr-line-dashed"></div>
                                  <div class="form-group"><label class="control-label">* Joining Year</label>
                                        <select name="year" class="form-control">
                                                  <option value="<?php echo $year; ?>" selected="selected"><?php echo $year;?></option>
                                        <option value="<?php echo date('Y',$timenow); ?>"><?php echo date('Y',$timenow); ?></option>
                                                            <?php
                                                            $datenow=date('Y',$timenow); 
                                                                 for ($x = 0; $x <= 15; $x++) {
                                                                     $datenow=$datenow-1;
                                                      echo '<option value="'.$datenow.'">'.$datenow.'</option>';
                                                                        }
                                                                                  ?> 
                                        </select>
                                                                        </div>
                                        <div class="form-group"><label class="control-label">* Joining Term</label>
                                        <select name="term" class="form-control">
                                            <option value="<?php echo $term;?>"><?php echo $term; ?></option>
                                           <option value="1">Term 1</option>
                                            <option value="2">Term 2</option>
                                            <option value="3">Term 3</option>
                                        </select>
                                        </div>
                                                                                                 <div class="form-group" id="data_1">
                              <label class="control-label">Birthday</label>
                              <input class="form-control form-control-inline input-medium default-date-picker"  name="birthday"  size="16" type="text"  value="<?php    if(!empty($birthday)){
                        echo date('m-d-Y',$birthday); 
                        }?>"/>
                                                              </div>
                                                    
                                  <div class="form-group"><label class="control-label">Profile picture (Leave Blank if not Changing)</label>

                             <input type="file"  name="image" class="form-control " style="padding: 0px"></div>
                             
                                   <div class="form-group"><label class="control-label">Nationality</label>
                                       <input type="text" name='nationality' class="form-control" placeholder="Enter Student Nationality" value="<?php echo htmlspecialchars($nationality, ENT_QUOTES); ?>">
                                                                            </div>
                                 <div class="form-group"><label class="control-label">Phone Number</label>
                                     <input type="text" name='number' class="form-control" placeholder="Enter Phone Number" value="<?php echo htmlspecialchars($number, ENT_QUOTES);?>">
                                                                            </div>
                                                          <div class="form-group">
                                                              <label class="control-label">Student Number</label>
                                                              <input type="text" name='regnumber' class="form-control" placeholder="Enter Student Number" value="<?php echo htmlspecialchars($regnumber, ENT_QUOTES); ?>">
                                                                            </div>       
                                <h2>Parents Details</h2>
                                <div class='row'>
                                <div class='col-lg-6'>
                                <h4>Father's Details</h4>
                                    <div class="form-group">
                                                              <label class="control-label">Father's Name</label>
                                                              <input type="text" name='fathername' class="form-control" placeholder="Enter Father's name" value="<?php echo htmlspecialchars($fathername, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Occupation</label>
                         <input type="text" name='fatheroccupation' class="form-control" placeholder="Enter Father's Occupation" value="<?php echo htmlspecialchars($fatheroccupation, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Contact Number</label>
                         <input type="text" name='fatherphone' class="form-control" placeholder="Enter Father's contact" value="<?php echo htmlspecialchars($fatherphone, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Father's Email</label>
                         <input type="text" name='fatheremail' class="form-control" placeholder="Enter Father's email" value="<?php echo htmlspecialchars($fatheremail, ENT_QUOTES);?>">
                                                                            </div> 
                                      </div>
                                      <div class='col-lg-6'>
                                <h4>Mother's Details</h4>
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Name</label>
                         <input type="text" name='mothername' class="form-control" placeholder="Enter Mother's name" value="<?php echo htmlspecialchars($mothername, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Occupation</label>
                         <input type="text" name='motheroccupation' class="form-control" placeholder="Enter Mother's Occupation" value="<?php echo htmlspecialchars($motheroccupation, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Contact Number</label>
                         <input type="text" name='motherphone' class="form-control" placeholder="Enter Mother's contact" value="<?php echo htmlspecialchars($motherphone, ENT_QUOTES);?>">
                                                                            </div> 
                                   <div class="form-group">
                                                              <label class="control-label">Mother's Email</label>
                         <input type="text" name='motheremail' class="form-control" placeholder="Enter Mother's email" value="<?php echo htmlspecialchars($motheremail, ENT_QUOTES);?>">
                                                                            </div> 
                                      </div>
                                    
                                                                </div>
                                <div class="form-group">
                                        <button class="btn btn-primary" type="submit">Edit Student</button>
                                </div>
                            </form>

                    </div>
                </section>
           
            </div>

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/gen_validatorv4.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
</body>
</html>
