<?php
include 'includes/conn.php';
// require session
if (!isset($_SESSION['schoolsys'])) {
    header('Location:login');
    exit;
}

// Only allow admin levels 1 or 2
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location: login');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Edit Signatures</title>
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/chosen/chosen.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="<?php echo BASE_URL; ?>/js/html5shiv.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
$    <?php include 'includes/header.php'; ?>

    <?php

$msg = '';
$errors = [];

// CSRF token generation
if (!isset($_SESSION['csrf_token'])) {
    if (function_exists('random_bytes')) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    } else {
        $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(32));
    }
}
$csrf_token = $_SESSION['csrf_token'];

// helper to save uploaded signature
function handle_signature_upload($fileField, $staff_id) {
    global $errors;
    if (!isset($_FILES[$fileField]) || $_FILES[$fileField]['error'] === UPLOAD_ERR_NO_FILE) return null;
    $f = $_FILES[$fileField];
    if ($f['error'] !== UPLOAD_ERR_OK) {
        $errors[] = 'File upload error for ' . htmlspecialchars($fileField);
        return null;
    }
    if ($f['size'] > 2 * 1024 * 1024) { // 2MB limit
        $errors[] = 'Signature file too large (max 2MB).';
        return null;
    }
    $ext = strtolower(pathinfo($f['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','gif'];
    if (!in_array($ext, $allowed)) {
        $errors[] = 'Invalid file type. Allowed: jpg, jpeg, png, gif.';
        return null;
    }
    $destDir = __DIR__ . '/images/nonteaching/';
    if (!is_dir($destDir)) @mkdir($destDir, 0755, true);
    $destName = md5($staff_id) . '.' . $ext;
    $destPath = $destDir . $destName;
    if (!move_uploaded_file($f['tmp_name'], $destPath)) {
        $errors[] = 'Could not move uploaded file.';
        return null;
    }
    return $ext;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate CSRF token
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $errors[] = 'Invalid request (CSRF token mismatch). Please refresh the page and try again.';
    }

    // Only proceed if CSRF passed
    if (empty($errors)) {
        // Principal update (use prepared statements)
        if (isset($_POST['principal_id'])) {
            $principal_id = filter_input(INPUT_POST, 'principal_id', FILTER_VALIDATE_INT);
            $principal_name = trim((string)filter_input(INPUT_POST, 'principal_name', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
            if ($principal_id !== false && $principal_id !== null) {
                if ($principal_name !== '') {
                    $stmt = mysqli_prepare($con, 'UPDATE staff SET fullname=? WHERE staff_id=?');
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'si', $principal_name, $principal_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    } else {
                        $errors[] = 'Database error (prepare failed).';
                    }
                }
                $ext = handle_signature_upload('principal_signature', $principal_id);
                if ($ext !== null) {
                    $stmt = mysqli_prepare($con, 'UPDATE staff SET sign_ext=? WHERE staff_id=?');
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'si', $ext, $principal_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    } else {
                        $errors[] = 'Database error (prepare failed).';
                    }
                }
                // Optionally set designation
                if (!empty($_POST['set_principal_designation']) && $_POST['set_principal_designation'] === '1') {
                    // clear previous principal designation
                    $stmt = mysqli_prepare($con, "UPDATE staff SET designation='' WHERE designation='Principal'");
                    if ($stmt) { mysqli_stmt_execute($stmt); mysqli_stmt_close($stmt); }
                    
                    // set new principal designation
                    $stmt = mysqli_prepare($con, "UPDATE staff SET designation='Principal' WHERE staff_id=?");
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'i', $principal_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    }
                    
                    // Update users table: clear previous principal (level 2), then set new one
                    $stmt = mysqli_prepare($con, "UPDATE users SET level=1 WHERE level=2");
                    if ($stmt) { mysqli_stmt_execute($stmt); mysqli_stmt_close($stmt); }
                    
                    $stmt = mysqli_prepare($con, "UPDATE users SET level=2 WHERE staff_id=? AND status=1");
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'i', $principal_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    }
                }
            }
        }

        // Headteacher update (prepared statements)
        if (isset($_POST['head_id'])) {
            $head_id = filter_input(INPUT_POST, 'head_id', FILTER_VALIDATE_INT);
            $head_name = trim((string)filter_input(INPUT_POST, 'head_name', FILTER_SANITIZE_FULL_SPECIAL_CHARS));
            if ($head_id !== false && $head_id !== null) {
                if ($head_name !== '') {
                    $stmt = mysqli_prepare($con, 'UPDATE staff SET fullname=? WHERE staff_id=?');
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'si', $head_name, $head_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    } else {
                        $errors[] = 'Database error (prepare failed).';
                    }
                }
                $ext2 = handle_signature_upload('head_signature', $head_id);
                if ($ext2 !== null) {
                    $stmt = mysqli_prepare($con, 'UPDATE staff SET sign_ext=? WHERE staff_id=?');
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'si', $ext2, $head_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    } else {
                        $errors[] = 'Database error (prepare failed).';
                    }
                }
                if (!empty($_POST['set_head_designation']) && $_POST['set_head_designation'] === '1') {
                    // clear previous head teacher designation
                    $stmt = mysqli_prepare($con, "UPDATE staff SET designation='' WHERE designation='Head Teacher'");
                    if ($stmt) { mysqli_stmt_execute($stmt); mysqli_stmt_close($stmt); }
                    
                    // set new head teacher designation
                    $stmt = mysqli_prepare($con, "UPDATE staff SET designation='Head Teacher' WHERE staff_id=?");
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'i', $head_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    }
                    
                    // Update users table: clear previous head teacher (level 4), then set new one
                    $stmt = mysqli_prepare($con, "UPDATE users SET level=1 WHERE level=4");
                    if ($stmt) { mysqli_stmt_execute($stmt); mysqli_stmt_close($stmt); }
                    
                    $stmt = mysqli_prepare($con, "UPDATE users SET level=4 WHERE staff_id=? AND status=1");
                    if ($stmt) {
                        mysqli_stmt_bind_param($stmt, 'i', $head_id);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    }
                }
            }
        }

    if (empty($errors)) {
        $msg = 'Updates saved successfully.';
        // Optionally rotate token after successful post to avoid replay
        try {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
            $csrf_token = $_SESSION['csrf_token'];
        } catch (Exception $e) {
            unset($_SESSION['csrf_token']);
            $csrf_token = '';
        }
    }
    }
}

// Load list of active staff for selection
 $staffList = [];
 $staffRes = mysqli_query($con, "SELECT staff_id, fullname, designation, sign_ext FROM staff WHERE status=1 ORDER BY fullname");
 if ($staffRes) {
     while ($s = mysqli_fetch_assoc($staffRes)) $staffList[] = $s;
 }

// Load current principal / headteacher if present
 $currPrincipal = null;
 $currHead = null;
 $r = mysqli_query($con, "SELECT staff_id, fullname, sign_ext FROM staff WHERE designation='Principal' AND status=1 LIMIT 1");
 if ($r) $currPrincipal = mysqli_fetch_assoc($r);
 $r2 = mysqli_query($con, "SELECT staff_id, fullname, sign_ext FROM staff WHERE designation='Head Teacher' AND status=1 LIMIT 1");
 if ($r2) $currHead = mysqli_fetch_assoc($r2);

?>

<!-- page content -->
    <section class="wrapper">
      <div class="row">
    <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              Edit Principal &amp; Head Teacher Signatures
            </header>
            <div class="panel-body">

    <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
    <?php if (!empty($errors)): ?><div class="alert alert-danger"><?php echo implode('<br>', array_map('htmlspecialchars', $errors)); ?></div><?php endif; ?>

    <form method="post" enctype="multipart/form-data" id="sign_form">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
        <div class="form-group">
            <h2>Principal</h2>
                        <label for="principal_id">Select Staff (Principal)</label>
                        <div class="row">
                            <div class="col-xs-8">
                                <select id="principal_id" name="principal_id" class="form-control">
                                    <?php foreach ($staffList as $s): ?>
                                            <?php $s_signsrc = (!empty($s['sign_ext']) ? (BASE_URL . '/images/nonteaching/' . md5($s['staff_id']) . '.' . $s['sign_ext']) : ''); ?>
                                        <option value="<?php echo $s['staff_id']; ?>" <?php echo (isset($currPrincipal['staff_id']) && $currPrincipal['staff_id']==$s['staff_id'])? 'selected' : ''; ?> data-signsrc="<?php echo $s_signsrc; ?>"><?php echo htmlspecialchars($s['fullname'] . ' (' . $s['designation'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-xs-4 text-center">
                                <?php $p_preview = (!empty($currPrincipal['sign_ext']) && !empty($currPrincipal['staff_id'])) ? (BASE_URL . '/images/nonteaching/' . md5($currPrincipal['staff_id']) . '.' . $currPrincipal['sign_ext']) : ''; ?>
                                <img id="principal_preview" class="img-responsive" style="max-width:120px; margin-top:8px;" src="<?php echo $p_preview; ?>" alt="Principal signature">
                            </div>
                        </div>

            <label for="principal_name">Principal Name</label>
            <input id="principal_name" name="principal_name" type="text" class="form-control" value="<?php echo isset($currPrincipal['fullname'])? htmlspecialchars($currPrincipal['fullname']) : ''; ?>">

            <label for="principal_signature">Upload Principal Signature (jpg/png/gif, max 2MB)</label>
            <input id="principal_signature" name="principal_signature" type="file" accept="image/*" data-existing="<?php echo !empty($p_preview) ? '1' : '0'; ?>">
            <?php if (!empty($currPrincipal['sign_ext']) && !empty($currPrincipal['staff_id'])): ?>
                <img class="img-responsive" style="max-width:220px; margin-top:8px;" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($currPrincipal['staff_id']) . '.' . $currPrincipal['sign_ext']; ?>" alt="Principal signature">
            <?php endif; ?>
            <div class="checkbox">
                <label><input type="checkbox" name="set_principal_designation" value="1"> Set selected staff as Principal</label>
            </div>
        </div>

        <div class="form-group">
            <h2>Head Teacher</h2>
                        <label for="head_id">Select Staff (Head Teacher)</label>
                        <div class="row">
                            <div class="col-xs-8">
                                <select id="head_id" name="head_id" class="form-control">
                                    <?php foreach ($staffList as $s): ?>
                                        <?php $s_signsrc = (!empty($s['sign_ext']) ? (BASE_URL . '/images/nonteaching/' . md5($s['staff_id']) . '.' . $s['sign_ext']) : ''); ?>
                                        <option value="<?php echo $s['staff_id']; ?>" <?php echo (isset($currHead['staff_id']) && $currHead['staff_id']==$s['staff_id'])? 'selected' : ''; ?> data-signsrc="<?php echo $s_signsrc; ?>"><?php echo htmlspecialchars($s['fullname'] . ' (' . $s['designation'] . ')'); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-xs-4 text-center">
                                <?php $h_preview = (!empty($currHead['sign_ext']) && !empty($currHead['staff_id'])) ? (BASE_URL . '/images/nonteaching/' . md5($currHead['staff_id']) . '.' . $currHead['sign_ext']) : ''; ?>
                                <img id="head_preview" class="img-responsive" style="max-width:120px; margin-top:8px;" src="<?php echo $h_preview; ?>" alt="Head teacher signature">
                            </div>
                        </div>

            <label for="head_name">Head Teacher Name</label>
            <input id="head_name" name="head_name" type="text" class="form-control" value="<?php echo isset($currHead['fullname'])? htmlspecialchars($currHead['fullname']) : ''; ?>">

            <label for="head_signature">Upload Head Teacher Signature (jpg/png/gif, max 2MB)</label>
            <input id="head_signature" name="head_signature" type="file" accept="image/*" data-existing="<?php echo !empty($h_preview) ? '1' : '0'; ?>">
            <?php if (!empty($currHead['sign_ext']) && !empty($currHead['staff_id'])): ?>
                <img class="img-responsive" style="max-width:220px; margin-top:8px;" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($currHead['staff_id']) . '.' . $currHead['sign_ext']; ?>" alt="Head teacher signature">
            <?php endif; ?>
            <div class="checkbox">
                <label><input type="checkbox" name="set_head_designation" value="1"> Set selected staff as Head Teacher</label>
            </div>
        </div>

        <button class="btn btn-primary" type="submit">Save Changes</button>
    </form>

            </div>
          </section>
        </div>
      </div>
    </section>

        </section>

        </div>


        </div>
        <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
    </section>

    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
    <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/gen_validatorv4.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/chosen/chosen.jquery.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

        <script>
            (function($){
                $(document).ready(function(){
                    // set initial previews from selected options
                    var pOpt = $('#principal_id option:selected').data('signsrc');
                    if (pOpt) $('#principal_preview').attr('src', pOpt);
                    var hOpt = $('#head_id option:selected').data('signsrc');
                    if (hOpt) $('#head_preview').attr('src', hOpt);

                    $('#principal_id').on('change', function(){
                        var signsrc = $(this).find('option:selected').data('signsrc') || '';
                        $('#principal_preview').attr('src', signsrc);
                    });

                    $('#head_id').on('change', function(){
                        var signsrc = $(this).find('option:selected').data('signsrc') || '';
                        $('#head_preview').attr('src', signsrc);
                    });

                    // Confirm replace if a file is selected and there is an existing signature
                    $('#sign_form').on('submit', function(e){
                        var pFile = $('#principal_signature').val();
                        var hFile = $('#head_signature').val();
                        var pExisting = $('#principal_signature').data('existing');
                        var hExisting = $('#head_signature').data('existing');
                        var msgs = [];
                        if(pFile && pExisting == '1') msgs.push('You are about to replace the existing Principal signature. Continue?');
                        if(hFile && hExisting == '1') msgs.push('You are about to replace the existing Head Teacher signature. Continue?');
                        if(msgs.length){
                            var ok = confirm(msgs.join('\n'));
                            if(!ok){
                                e.preventDefault();
                                return false;
                            }
                        }
                        return true;
                    });
                });
            })(jQuery);
        </script>

</body>

</html>
