<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Only Finance, Accounts, Super Admin, Principal can access
if (!isset($_SESSION['schoolsyslevel']) || !in_array($_SESSION['schoolsyslevel'], [1,2,3,8,10])){
    header('Location:login.php');
    exit;
}

$familyId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($familyId <= 0) {
    header('Location: familymanagement.php');
    exit;
}

// Ensure families table exists
$tableCheck = mysqli_query($con, "SHOW TABLES LIKE 'families'");
if (!$tableCheck || mysqli_num_rows($tableCheck) === 0) {
    die('Families table not found. Please run sql/family_discount_enhancements.sql');
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $family_name = mysqli_real_escape_string($con, trim($_POST['family_name'] ?? ''));
    $primary_contact_name = mysqli_real_escape_string($con, trim($_POST['primary_contact_name'] ?? ''));
    $primary_contact_phone = mysqli_real_escape_string($con, trim($_POST['primary_contact_phone'] ?? ''));
    $primary_contact_email = mysqli_real_escape_string($con, trim($_POST['primary_contact_email'] ?? ''));
    $secondary_contact_phone = mysqli_real_escape_string($con, trim($_POST['secondary_contact_phone'] ?? ''));
    $secondary_contact_email = mysqli_real_escape_string($con, trim($_POST['secondary_contact_email'] ?? ''));
    $address = mysqli_real_escape_string($con, trim($_POST['address'] ?? ''));
    $notes = mysqli_real_escape_string($con, trim($_POST['notes'] ?? ''));
    $status = isset($_POST['status']) ? (int)$_POST['status'] : 1;

    $update = mysqli_query($con, "UPDATE families SET 
        family_name='$family_name',
        primary_contact_name='$primary_contact_name',
        primary_contact_phone='$primary_contact_phone',
        primary_contact_email='$primary_contact_email',
        secondary_contact_phone='$secondary_contact_phone',
        secondary_contact_email='$secondary_contact_email',
        address='$address',
        notes='$notes',
        status=$status
        WHERE family_id=$familyId
    ");

    if ($update) {
        $message = 'Family details updated successfully.';
    } else {
        $error = 'Failed to update family. Please try again.';
    }
}

$familyQ = mysqli_query($con, "SELECT * FROM families WHERE family_id=$familyId LIMIT 1");
$family = mysqli_fetch_assoc($familyQ);
if (!$family) {
    die('Family not found');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Family - ID <?php echo $familyId; ?></title>
  <link href="css/bootstrap.min.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">
            <h3><i class="fa fa-edit"></i> Edit Family (ID <?php echo $familyId; ?>)</h3>
            <a href="familymanagement.php" class="btn btn-default btn-sm" style="margin-top:10px;">Back to Family Management</a>
          </header>
          <div class="panel-body">
            <?php if ($message): ?>
              <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            <?php if ($error): ?>
              <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>
            <form class="form-horizontal" method="post">
              <div class="form-group">
                <label class="col-sm-3 control-label">Family Name</label>
                <div class="col-sm-9">
                  <input type="text" name="family_name" class="form-control" value="<?php echo htmlspecialchars($family['family_name'] ?? ''); ?>" required>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Primary Contact Name</label>
                <div class="col-sm-9">
                  <input type="text" name="primary_contact_name" class="form-control" value="<?php echo htmlspecialchars($family['primary_contact_name'] ?? ''); ?>">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Primary Phone</label>
                <div class="col-sm-9">
                  <input type="text" name="primary_contact_phone" class="form-control" value="<?php echo htmlspecialchars($family['primary_contact_phone'] ?? ''); ?>">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Primary Email</label>
                <div class="col-sm-9">
                  <input type="email" name="primary_contact_email" class="form-control" value="<?php echo htmlspecialchars($family['primary_contact_email'] ?? ''); ?>">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Secondary Phone</label>
                <div class="col-sm-9">
                  <input type="text" name="secondary_contact_phone" class="form-control" value="<?php echo htmlspecialchars($family['secondary_contact_phone'] ?? ''); ?>">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Secondary Email</label>
                <div class="col-sm-9">
                  <input type="email" name="secondary_contact_email" class="form-control" value="<?php echo htmlspecialchars($family['secondary_contact_email'] ?? ''); ?>">
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Address</label>
                <div class="col-sm-9">
                  <textarea name="address" class="form-control" rows="2"><?php echo htmlspecialchars($family['address'] ?? ''); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Notes</label>
                <div class="col-sm-9">
                  <textarea name="notes" class="form-control" rows="3"><?php echo htmlspecialchars($family['notes'] ?? ''); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-3 control-label">Status</label>
                <div class="col-sm-9">
                  <select name="status" class="form-control">
                    <option value="1" <?php echo ((int)$family['status'] === 1 ? 'selected' : ''); ?>>Active</option>
                    <option value="0" <?php echo ((int)$family['status'] === 0 ? 'selected' : ''); ?>>Inactive</option>
                  </select>
                </div>
              </div>
              <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                  <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save Changes</button>
                  <a href="familymanagement.php" class="btn btn-default">Cancel</a>
                </div>
              </div>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
