<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Only Super Admin
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if ($user_level != 1) {
    header('Location: login.php');
    exit();
}

$file = $_GET['file'] ?? '';
if (empty($file)) {
    http_response_code(400);
    echo 'Missing file parameter';
    exit();
}

$safe = basename($file);
$path = __DIR__ . DIRECTORY_SEPARATOR . 'backups' . DIRECTORY_SEPARATOR . $safe;

if (!file_exists($path) || strpos($safe, 'backup_') !== 0) {
    http_response_code(404);
    echo 'Backup not found';
    exit();
}

header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($path) . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($path));
readfile($path);
exit();
