<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Ensure session level exists and user has access
// Allow Super Admin(1), Principal(2), Accounts Management(3), Finance Manager(8), HR Admin Director(9), Accountant(10)
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,9,10], true)) {
  header('Location: login.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Discounts</title>
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />

  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>
        <section class="wrapper">
             <div class="row">        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                 Fees Discounts
                    </header>
                            <div class="panel-body">
                <?php
                $getdiscounts = mysqli_query($con, "SELECT * FROM discounts WHERE status=1");
                if ($getdiscounts && mysqli_num_rows($getdiscounts) > 0) {
                ?>
              <table  class="display table  table-striped" id="dynamic-table">
                    <thead>
                    <tr>
                           <th>Student</th> 
                        <th>Term &  Year</th>                          
                        <th>Discount (%)</th>      
                            <?php 
                             // Show Action column to finance/account roles: Super Admin(1), Principal(2), Accounts Management(3), Finance Manager(8), HR Admin Director(9), Accountant(10)
                             if (isset($_SESSION['schoolsyslevel']) && in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,9,10], true)) {
                               ?>  
                          <th>Action</th>
                             <?php } ?>
                    </tr>
                    </thead>
                    <tbody>
              <?php
                 while ($row = mysqli_fetch_array($getdiscounts)) {
                   $discount_id = $row['discount_id'] ?? 0;
                   $term_id = $row['term_id'] ?? 0;
                   $discount = $row['discount'] ?? 0;
                   $class_id = $row['class_id'] ?? 0;
                   $student_id = $row['student_id'] ?? 0;

                   // fetch student safely
                   $fullname = '-';
                   if ($student_id) {
                     $getstudent = mysqli_query($con, "SELECT fullname FROM students WHERE status=1 AND student_id='" . (int)$student_id . "' LIMIT 1");
                     if ($getstudent && mysqli_num_rows($getstudent) > 0) {
                       $row1 = mysqli_fetch_assoc($getstudent);
                       $fullname = $row1['fullname'] ?? '-';
                     }
                   }

                   // fetch term safely
                   $term = '-';
                   $year = '';
                   if ($term_id) {
                     $terms = mysqli_query($con, "SELECT term,`year` FROM financialterms WHERE financialterm_id='" . (int)$term_id . "' LIMIT 1");
                     if ($terms && mysqli_num_rows($terms) > 0) {
                       $row2 = mysqli_fetch_assoc($terms);
                       $term = $row2['term'] ?? '-';
                       $year = $row2['year'] ?? '';
                     }
                   }
                  ?>
               
                    <tr class="gradeA">
                    <td><?php echo $fullname; ?></td>
                    <td><?php echo 'Term '.$term.' '.$year; ?></td>
                        <td><?php echo $discount; ?></td>
                  <?php 
                             // Show action buttons to finance/account roles
                             if (isset($_SESSION['schoolsyslevel']) && in_array((int)$_SESSION['schoolsyslevel'], [1,2,3,8,9,10], true)) {
                                 ?>      
  <td>        
                      <a href="editdiscount?id=<?php echo $discount_id; ?>&&std=<?php echo $student_id; ?>"  class="btn btn-info  btn-xs">Edit <i class="fa fa-edit"></i></a>
                        <a href="hidediscount?id=<?php echo $discount_id; ?>"  class="btn btn-danger  btn-xs" onclick="return confirm_delete<?php echo $discount_id;?>()">Delete <i class="fa fa-trash-o"></i></a>
                                
                                                         <script type="text/javascript">
function confirm_delete<?php echo $discount_id; ?>() {
  return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>                 
  </td>
       <?php } ?> 
                    </tr>
                 <?php }?>
                      </tbody>
                                </table>
         <?php } else { ?>
           <div class="alert alert-info">No discounts found.</div>
         <?php } ?>
                          </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<!-- Placed js at the end of the document so the pages load faster -->
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>

</body>
</html>
