<?php
include 'includes/conn.php';
include 'includes/roles.php';

// require elevated permissions
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!hasFullFinancialPermissions($user_level)) {
    header('Location:login.php');
    exit();
}

$contract_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($contract_id <= 0) {
    $_SESSION['message'] = 'Invalid contract id.';
    $_SESSION['msg_type'] = 'danger';
    header('Location: vendorcontracts.php');
    exit();
}

$res = mysqli_query($con, "SELECT vendor_id FROM vendor_contracts WHERE contract_id='" . intval($contract_id) . "' LIMIT 1");
if (!$res || mysqli_num_rows($res) === 0) {
    $_SESSION['message'] = 'Contract not found.';
    $_SESSION['msg_type'] = 'warning';
    header('Location: vendorcontracts.php');
    exit();
}
$row = mysqli_fetch_assoc($res);
$vendor_id = (int)$row['vendor_id'];

$stmt = mysqli_prepare($con, "DELETE FROM vendor_contracts WHERE contract_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $contract_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    $_SESSION['message'] = 'Contract deleted.';
    $_SESSION['msg_type'] = 'success';
} else {
    $_SESSION['message'] = 'Database error: ' . mysqli_error($con);
    $_SESSION['msg_type'] = 'danger';
}

header('Location: vendorcontracts.php?id=' . $vendor_id);
exit();
