<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) { header('Location:login.php'); exit; }

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { header('Location: accountspayable.php'); exit; }

$check = mysqli_query($con, "SHOW TABLES LIKE 'payment_schedule'");
if (!$check || mysqli_num_rows($check) === 0) { die('payment_schedule table not found. Run create_accounting_tables.sql'); }

$stmt = mysqli_prepare($con, "SELECT * FROM payment_schedule WHERE schedule_id = ? LIMIT 1");
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);
if (!$row) { header('Location: paymentschedule.php'); exit; }

// Ensure expected keys exist to avoid PHP 7/8 warnings when rendering
$defaults = [
  'payment_number' => 0,
  'scheduled_date' => '',
  'amount_due' => 0.0,
  'payment_method_id' => 0,
  'amount_paid' => 0.0,
  'payment_date' => '',
  'status' => '',
  'payable_id' => 0
];
$row = array_merge($defaults, (array)$row);

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    $del = mysqli_prepare($con, "DELETE FROM payment_schedule WHERE schedule_id = ?");
    if ($del) {
        mysqli_stmt_bind_param($del, 'i', $id);
        if (mysqli_stmt_execute($del)) {
            mysqli_stmt_close($del);
            header('Location: paymentschedule.php?payable_id=' . (int)$row['payable_id']);
            exit;
        } else {
            $error = 'Delete failed: ' . mysqli_error($con);
        }
    } else {
        $error = 'Database error: ' . mysqli_error($con);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Delete Schedule Entry</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading bg-danger">
            <i class="fa fa-trash"></i> Delete Schedule Entry
          </header>
          <div class="panel-body">
            <?php if (!empty($error)) { echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>'; } ?>
            <table class="table table-bordered">
              <tr><th>Payment #</th><td><?php echo (int)$row['payment_number']; ?></td></tr>
              <tr><th>Scheduled Date</th><td><?php echo htmlspecialchars($row['scheduled_date']); ?></td></tr>
              <tr><th>Amount Due</th><td><?php echo number_format($row['amount_due'],2); ?></td></tr>
              <tr><th>Status</th><td><?php echo htmlspecialchars($row['status']); ?></td></tr>
            </table>
            <form method="post" action="">
              <p class="text-danger"><strong>Are you sure you want to permanently delete this schedule entry?</strong></p>
              <button type="submit" name="confirm_delete" value="1" class="btn btn-danger">Yes, Delete</button>
              <a href="paymentschedule.php?payable_id=<?php echo (int)$row['payable_id']; ?>" class="btn btn-default">Cancel</a>
            </form>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
