<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys']) || (int)$_SESSION['schoolsyslevel'] !== 1) {
  header('Location: login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: notices.php');
  exit;
}

// Fetch notice details for confirmation
$stmt = mysqli_prepare($con, "SELECT financialterm_id, term, year, academic_year, important_notice FROM financialterms WHERE financialterm_id = ?");
if ($stmt) {
  mysqli_stmt_bind_param($stmt, 'i', $id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  $row = mysqli_fetch_assoc($result);
  
  if (!$row) {
    header('Location: notices.php');
    exit;
  }
  
  $term = (int)$row['term'];
  $year = $row['year'] ?? '';
  $acad_year = $row['academic_year'] ?? '';
  $notice = $row['important_notice'] ?? '';
  
  mysqli_stmt_close($stmt);
} else {
  header('Location: notices.php');
  exit;
}

// Handle deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
  $delete_stmt = mysqli_prepare($con, "UPDATE financialterms SET important_notice = '' WHERE financialterm_id = ?");
  if ($delete_stmt) {
    mysqli_stmt_bind_param($delete_stmt, 'i', $id);
    if (mysqli_stmt_execute($delete_stmt)) {
      mysqli_stmt_close($delete_stmt);
      header('Location: notices.php?msg=deleted');
      exit;
    } else {
      $error_message = 'Failed to delete notice. Please try again.';
    }
    mysqli_stmt_close($delete_stmt);
  } else {
    $error_message = 'Database error. Please try again.';
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Delete Important Notice | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>

  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8">
        <section class="panel">
          <header class="panel-heading bg-danger">
            <i class="fa fa-warning"></i> Delete Important Notice
          </header>
          <div class="panel-body">
            <?php if (isset($error_message)): ?>
              <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?php echo htmlspecialchars($error_message); ?>
              </div>
            <?php endif; ?>
            
            <div class="alert alert-warning">
              <strong><i class="fa fa-warning"></i> Warning!</strong> You are about to delete the important notice for this term.
            </div>
            
            <div class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Term:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static">Term <?php echo $term; ?></p>
                </div>
              </div>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Academic Year:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo htmlspecialchars($acad_year); ?></p>
                </div>
              </div>
              
              <hr>
              
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Notice to Delete:</strong></label>
                <div class="col-sm-9">
                  <div class="well">
                    <?php echo !empty($notice) ? nl2br(htmlspecialchars($notice)) : '<em class="text-muted">No notice to delete</em>'; ?>
                  </div>
                </div>
              </div>
              
              <hr>
              
              <form method="POST" action="">
                <div class="form-group">
                  <div class="col-sm-offset-3 col-sm-9">
                    <p class="text-danger"><strong>Are you sure you want to delete this notice?</strong></p>
                    <button type="submit" name="confirm_delete" value="1" class="btn btn-danger">
                      <i class="fa fa-trash"></i> Yes, Delete Notice
                    </button>
                    <a href="notices.php" class="btn btn-default">
                      <i class="fa fa-times"></i> No, Cancel
                    </a>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
