<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys'])) {
  header('Location: login.php');
  exit;
}

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location: feestructures.php');
  exit;
}

// Fetch the fee structure to show details
// Use actual column names from the schema (see sql/create_accounting_tables.sql)
$stmt = mysqli_prepare($con, "SELECT fee_structure_id, structure_name, description, total_fee, created_at FROM fee_structures WHERE fee_structure_id = ? LIMIT 1");
if ($stmt) {
  mysqli_stmt_bind_param($stmt, 'i', $id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  $row = mysqli_fetch_assoc($result);
  mysqli_stmt_close($stmt);
} else {
  header('Location: feestructures.php');
  exit;
}

if (!$row) {
  header('Location: feestructures.php');
  exit;
}

// Handle deletion when confirmed
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
  $del = mysqli_prepare($con, "DELETE FROM fee_structures WHERE fee_structure_id = ?");
  if ($del) {
    mysqli_stmt_bind_param($del, 'i', $id);
    if (mysqli_stmt_execute($del)) {
      mysqli_stmt_close($del);
      header('Location: feestructures.php?msg=deleted');
      exit;
    }
    mysqli_stmt_close($del);
    $error_message = 'Failed to delete fee structure. Please try again.';
  } else {
    $error_message = 'Database error. Please try again.';
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Delete Fee Structure | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>

  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8">
        <section class="panel">
          <header class="panel-heading bg-danger">
            <i class="fa fa-trash"></i> Delete Fee Structure
          </header>
          <div class="panel-body">
            <?php if (isset($error_message)): ?>
              <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?php echo htmlspecialchars($error_message); ?>
              </div>
            <?php endif; ?>

            <div class="alert alert-warning">
              <strong><i class="fa fa-warning"></i> Warning!</strong> You are about to permanently delete this fee structure.
            </div>

            <div class="form-horizontal">
              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Name:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo htmlspecialchars($row['structure_name'] ?? ''); ?></p>
                </div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Description:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo nl2br(htmlspecialchars($row['description'] ?? '')); ?></p>
                </div>
              </div>

              <div class="form-group">
                <label class="col-sm-3 control-label"><strong>Amount:</strong></label>
                <div class="col-sm-9">
                  <p class="form-control-static"><?php echo number_format((float)($row['total_fee'] ?? 0), 2); ?></p>
                </div>
              </div>

              <hr>

              <form method="POST" action="">
                <div class="form-group">
                  <div class="col-sm-offset-3 col-sm-9">
                    <p class="text-danger"><strong>Are you sure you want to delete this fee structure?</strong></p>
                    <button type="submit" name="confirm_delete" value="1" class="btn btn-danger">
                      <i class="fa fa-trash"></i> Yes, Delete
                    </button>
                    <a href="feestructures.php" class="btn btn-default">
                      <i class="fa fa-times"></i> Cancel
                    </a>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>
