<?php
// Debug helper: prints existence, columns and sample rows from fee_structures
include 'includes/conn.php';
header('Content-Type: text/plain; charset=utf-8');
if (session_status() === PHP_SESSION_NONE) { session_start(); }

echo "Debug: fee_structures\n";
$check = mysqli_query($con, "SHOW TABLES LIKE 'fee_structures'");
if (!$check) {
    echo "ERROR: Could not run SHOW TABLES: " . mysqli_error($con) . "\n";
    exit;
}
if (mysqli_num_rows($check) === 0) {
    echo "Table 'fee_structures' does NOT exist in DB '" . (mysqli_get_server_info($con) ?: '') . "'.\n";
    exit;
}

echo "Table exists.\n\n";

// show columns
$cols = [];
$colRes = mysqli_query($con, "SHOW COLUMNS FROM fee_structures");
if (!$colRes) {
    echo "ERROR: Could not fetch columns: " . mysqli_error($con) . "\n";
    exit;
}
while ($c = mysqli_fetch_assoc($colRes)) {
    $cols[] = $c;
}

echo "Columns (name => type):\n";
foreach ($cols as $c) {
    echo " - " . $c['Field'] . " => " . $c['Type'] . "\n";
}

// count rows
$countRes = mysqli_query($con, "SELECT COUNT(*) AS cnt FROM fee_structures");
if ($countRes) {
    $cr = mysqli_fetch_assoc($countRes);
    echo "\nRow count: " . ($cr['cnt'] ?? '0') . "\n";
} else {
    echo "\nCould not COUNT rows: " . mysqli_error($con) . "\n";
}

// show up to 50 rows
echo "\nSample rows (up to 50):\n";
$res = mysqli_query($con, "SELECT * FROM fee_structures ORDER BY fee_structure_id DESC LIMIT 50");
if (!$res) {
    echo "ERROR: SELECT failed: " . mysqli_error($con) . "\n";
    exit;
}
$rows = [];
while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = $r;
}

if (count($rows) === 0) {
    echo "(no rows)\n";
} else {
    foreach ($rows as $i => $r) {
        echo "--- Row " . ($i+1) . " ---\n";
        foreach ($r as $k => $v) {
            echo $k . ": " . (is_null($v) ? 'NULL' : $v) . "\n";
        }
    }
}

echo "\nDone.\n";
