<?php
include 'includes/conn.php';
include 'includes/roles.php';
include 'includes/backup_restore.php';

// Normalize user level (support legacy keys)
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
// Only Super Admin and Finance/Admin should view DB stats (adjust as needed)
$allowed = [1,3];
if (!in_array($user_level, $allowed)) {
    header('Location: login.php');
    exit();
}

$backup = new DatabaseBackup($con);
$stats = $backup->getDatabaseStats();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Statistics</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-bar-chart"></i> Database Statistics</h4>
                    </header>
                    <div class="panel-body">
                        <?php if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . '">' . htmlspecialchars($_SESSION['message']) . '</div>';
                            unset($_SESSION['message']); unset($_SESSION['msg_type']);
                        } ?>

                        <div class="row">
                            <div class="col-md-4">
                                <section class="panel">
                                    <div class="panel-body">
                                        <h5>Total Tables</h5>
                                        <p class="lead"><?php echo (int)($stats['tables'] ?? 0); ?></p>
                                    </div>
                                </section>
                            </div>
                            <div class="col-md-4">
                                <section class="panel">
                                    <div class="panel-body">
                                        <h5>Total Records</h5>
                                        <p class="lead"><?php echo (int)($stats['total_records'] ?? 0); ?></p>
                                    </div>
                                </section>
                            </div>
                            <div class="col-md-4">
                                <section class="panel">
                                    <div class="panel-body">
                                        <h5>Total Size</h5>
                                        <p class="lead"><?php echo isset($stats['total_size']) ? (function($s){
                                            $units = ['B','KB','MB','GB']; $i=0; while($s>1024 && $i<count($units)-1){ $s/=1024; $i++; } return round($s,2).' '.$units[$i];
                                        })($stats['total_size']) : '0 B'; ?></p>
                                    </div>
                                </section>
                            </div>
                        </div>

                        <h5 class="margin-top-20">Tables Detail</h5>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr><th>Table</th><th>Records</th><th>Size</th><th>Actions</th></tr>
                                </thead>
                                <tbody>
                                <?php foreach ($stats['tables_detail'] as $t) { ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($t['name']); ?></td>
                                        <td><?php echo (int)$t['records']; ?></td>
                                        <td><?php echo htmlspecialchars($t['size_formatted']); ?></td>
                                        <td>
                                            <a class="btn btn-default btn-xs" href="databasestats.php?optimize=<?php echo urlencode($t['name']); ?>">Optimize</a>
                                            <a class="btn btn-info btn-xs" href="databasestats.php?show_create=<?php echo urlencode($t['name']); ?>">Show CREATE</a>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>

                        <?php
                        // Handle actions: optimize or show create
                        if (isset($_GET['optimize'])) {
                            $tbl = mysqli_real_escape_string($con, $_GET['optimize']);
                            mysqli_query($con, "OPTIMIZE TABLE `$tbl`");
                            $_SESSION['message'] = "Optimized table $tbl";
                            $_SESSION['msg_type'] = 'success';
                            header('Location: databasestats.php'); exit();
                        }

                        if (isset($_GET['show_create'])) {
                            $tbl = mysqli_real_escape_string($con, $_GET['show_create']);
                            $res = mysqli_query($con, "SHOW CREATE TABLE `$tbl`");
                            if ($res && mysqli_num_rows($res) > 0) {
                                $row = mysqli_fetch_row($res);
                                echo '<h5 class="margin-top-20">CREATE for ' . htmlspecialchars($tbl) . '</h5>';
                                echo '<pre>' . htmlspecialchars($row[1]) . '</pre>';
                            } else {
                                echo '<div class="alert alert-warning">Could not fetch CREATE TABLE for ' . htmlspecialchars($tbl) . '</div>';
                            }
                        }
                        ?>

                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
