-- SQL to create missing reference tables for fee structures
-- Run this in phpMyAdmin or MySQL command line

-- Create academicyears table if it doesn't exist
CREATE TABLE IF NOT EXISTS `academicyears` (
  `academicyear_id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(50) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` int(2) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`academicyear_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create financialterms table if it doesn't exist
CREATE TABLE IF NOT EXISTS `financialterms` (
  `financialterm_id` int(11) NOT NULL AUTO_INCREMENT,
  `term` varchar(50) NOT NULL,
  `academic_year_id` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` int(2) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`financialterm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample academic years
INSERT INTO `academicyears` (`year`, `start_date`, `end_date`, `status`) VALUES
('2024/2025', '2024-09-01', '2025-08-31', 1),
('2025/2026', '2025-09-01', '2026-08-31', 1),
('2026/2027', '2026-09-01', '2027-08-31', 0)
ON DUPLICATE KEY UPDATE year=year;

-- Insert sample financial terms
INSERT INTO `financialterms` (`term`, `academic_year_id`, `start_date`, `end_date`, `status`) VALUES
('Term 1', 1, '2024-09-01', '2024-12-20', 1),
('Term 2', 1, '2025-01-06', '2025-04-10', 1),
('Term 3', 1, '2025-04-21', '2025-08-31', 1),
('Term 1', 2, '2025-09-01', '2025-12-20', 1),
('Term 2', 2, '2026-01-06', '2026-04-10', 1),
('Term 3', 2, '2026-04-21', '2026-08-31', 1)
ON DUPLICATE KEY UPDATE term=term;

-- Sample data is now ready for use in fee structures
