<?php
// Diagnostic script to check session state
include 'includes/conn.php';

echo "<!DOCTYPE html><html><head><title>Session Diagnostic</title></head><body>";
echo "<h2>Session Diagnostic Report</h2>";
echo "<p><strong>Date/Time:</strong> " . date('Y-m-d H:i:s') . "</p>";

echo "<h3>Session Status:</h3>";
echo "<p>Session Status: " . (session_status() === PHP_SESSION_ACTIVE ? "ACTIVE" : "INACTIVE") . "</p>";
echo "<p>Session ID: " . session_id() . "</p>";

echo "<h3>Session Variables:</h3>";
echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
echo "<tr><th>Key</th><th>Value</th></tr>";

if (!empty($_SESSION)) {
    foreach ($_SESSION as $key => $value) {
        $display_value = is_array($value) ? json_encode($value) : htmlspecialchars((string)$value);
        echo "<tr><td><strong>" . htmlspecialchars($key) . "</strong></td><td>" . $display_value . "</td></tr>";
    }
} else {
    echo "<tr><td colspan='2'><em>No session variables set</em></td></tr>";
}
echo "</table>";

echo "<h3>Session Role Level Check:</h3>";
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
echo "<p><strong>Computed user_level:</strong> $user_level</p>";
echo "<p><strong>secusyslevel isset?</strong> " . (isset($_SESSION['secusyslevel']) ? 'YES (value: ' . $_SESSION['secusyslevel'] . ')' : 'NO') . "</p>";
echo "<p><strong>schoolsyslevel isset?</strong> " . (isset($_SESSION['schoolsyslevel']) ? 'YES (value: ' . $_SESSION['schoolsyslevel'] . ')' : 'NO') . "</p>";
echo "<p><strong>secusys isset?</strong> " . (isset($_SESSION['secusys']) ? 'YES (value: ' . $_SESSION['secusys'] . ')' : 'NO') . "</p>";
echo "<p><strong>schoolsys isset?</strong> " . (isset($_SESSION['schoolsys']) ? 'YES (value: ' . $_SESSION['schoolsys'] . ')' : 'NO') . "</p>";

echo "<h3>Authorization Check for addsalary.php:</h3>";
$allowed_roles = [1,2,3,8,9,10];
$is_authorized = ($user_level !== 0 && in_array($user_level, $allowed_roles, true));
echo "<p><strong>Is Authorized?</strong> " . ($is_authorized ? "✓ YES" : "✗ NO") . "</p>";
echo "<p><strong>Allowed Roles:</strong> " . implode(', ', $allowed_roles) . "</p>";

if (!$is_authorized) {
    echo "<p style='color: red;'><strong>⚠ This user would be redirected to login from addsalary.php</strong></p>";
    if ($user_level === 0) {
        echo "<p style='color: orange;'>Reason: user_level is 0 (no session level found)</p>";
    } else {
        echo "<p style='color: orange;'>Reason: user_level $user_level is not in the allowed roles list</p>";
    }
} else {
    echo "<p style='color: green;'><strong>✓ This user would be allowed to access addsalary.php</strong></p>";
}

echo "<hr>";
echo "<p><a href='index.php'>Go to Dashboard</a> | <a href='addsalary.php?ty=1&id=1'>Test addsalary.php</a> | <a href='logout.php'>Logout</a></p>";
echo "</body></html>";
?>
