<?php
include 'includes/conn.php';
include 'includes/roles.php';

if (!canViewFinancialReports($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// Normalize date strings
$start_date_safe = mysqli_real_escape_string($con, $start_date);
$end_date_safe = mysqli_real_escape_string($con, $end_date);

// Inflows: fee collections (accounts_receivable / feespayment tables depending on installation)
$inflows_q = "SELECT COALESCE(SUM(amount_paid), 0) as total FROM accounts_receivable 
              WHERE status IN ('Paid', 'Partial') 
              AND DATE(updated_at) >= '$start_date_safe' AND DATE(updated_at) <= '$end_date_safe'";
$inflows_res = @mysqli_query($con, $inflows_q);
$inflows_row = $inflows_res ? mysqli_fetch_assoc($inflows_res) : ['total' => 0];
$inflows_total = (float)$inflows_row['total'];

// Outflows: expenses (expenses table stores `date` as unix timestamp in many schemas)
$outflows_q = "SELECT COALESCE(SUM(amount), 0) as total FROM expenses 
               WHERE status=1 AND FROM_UNIXTIME(`date`) >= '$start_date_safe' AND FROM_UNIXTIME(`date`) <= '$end_date_safe'";
$outflows_res = @mysqli_query($con, $outflows_q);
$outflows_row = $outflows_res ? mysqli_fetch_assoc($outflows_res) : ['total' => 0];
$outflows_total = (float)$outflows_row['total'];

// Net cash
$net = $inflows_total - $outflows_total;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Cash Flow Report</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-exchange"></i> Cash Flow: <?php echo htmlspecialchars($start_date); ?> — <?php echo htmlspecialchars($end_date); ?></h4>
                    </header>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="panel panel-success">
                                    <div class="panel-heading"><strong>Inflows</strong></div>
                                    <div class="panel-body">
                                        <h3 class="text-success"><?php echo number_format($inflows_total, 2); ?></h3>
                                        <p>Collections (accounts_receivable)</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-danger">
                                    <div class="panel-heading"><strong>Outflows</strong></div>
                                    <div class="panel-body">
                                        <h3 class="text-danger"><?php echo number_format($outflows_total, 2); ?></h3>
                                        <p>Expenses (expenses)</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading"><strong>Net Cash</strong></div>
                                    <div class="panel-body">
                                        <h3><?php echo number_format($net, 2); ?></h3>
                                        <p><?php echo $net >= 0 ? 'Positive' : 'Negative'; ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <p>
                            <a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a>
                        </p>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
