<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

if (!canManageBudgets($user_level)) {
    header('Location:login.php');
    exit();
}

$fiscal_year_filter = $_GET['year'] ?? '';
$status_filter = $_GET['status'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Budget Management</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-calculator"></i> Budget Management
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="addbudget.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> Create New Budget
                        </a>
                        
                        <!-- Filters -->
                        <div class="row margin-bottom-20">
                            <div class="col-md-4">
                                <select class="form-control" onchange="location = '?year=' + this.value;">
                                    <option value="">All Fiscal Years</option>
                                    <?php
                                    $years = mysqli_query($con, "SELECT DISTINCT fiscal_year FROM budgets WHERE fiscal_year IS NOT NULL ORDER BY fiscal_year DESC");
                                    while ($y = mysqli_fetch_array($years)) {
                                        echo '<option value="' . $y['fiscal_year'] . '"' . ($fiscal_year_filter == $y['fiscal_year'] ? ' selected' : '') . '>' . $y['fiscal_year'] . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <select class="form-control" onchange="location = '?status=' + this.value;">
                                    <option value="">All Status</option>
                                    <option value="Draft">Draft</option>
                                    <option value="Submitted">Submitted</option>
                                    <option value="Approved">Approved</option>
                                    <option value="Active">Active</option>
                                    <option value="Closed">Closed</option>
                                </select>
                            </div>
                        </div>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Budget Name</th>
                                    <th>Department</th>
                                    <th>Fiscal Year</th>
                                    <th>Total Budget</th>
                                    <th>Spent</th>
                                    <th>Remaining</th>
                                    <th>% Used</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT * FROM budgets WHERE 1=1";
                                
                                if ($fiscal_year_filter) {
                                    $query .= " AND fiscal_year = " . (int)$fiscal_year_filter;
                                }
                                if ($status_filter) {
                                    $query .= " AND status = '" . mysqli_real_escape_string($con, $status_filter) . "'";
                                }
                                
                                $query .= " ORDER BY fiscal_year DESC, created_at DESC";
                                
                                $result = mysqli_query($con, $query);
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        $pct_used = ($row['total_budget'] > 0) ? round(($row['spent_amount'] / $row['total_budget']) * 100, 1) : 0;
                                        
                                        $status_class = 'label-warning';
                                        if ($row['status'] == 'Active') $status_class = 'label-success';
                                        elseif ($row['status'] == 'Closed') $status_class = 'label-default';
                                        
                                        $pct_class = '';
                                        if ($pct_used >= 90) $pct_class = 'text-danger';
                                        elseif ($pct_used >= 75) $pct_class = 'text-warning';
                                        
                                        echo '<tr>
                                            <td><strong>' . htmlspecialchars($row['budget_name']) . '</strong></td>
                                            <td>' . htmlspecialchars($row['department'] ?? '-') . '</td>
                                            <td>' . $row['fiscal_year'] . '</td>
                                            <td>' . number_format($row['total_budget'], 2) . '</td>
                                            <td>' . number_format($row['spent_amount'], 2) . '</td>
                                            <td><strong>' . number_format($row['remaining_amount'], 2) . '</strong></td>
                                            <td><span class="' . $pct_class . '">' . $pct_used . '%</span></td>
                                            <td><span class="label ' . $status_class . '">' . htmlspecialchars($row['status']) . '</span></td>
                                            <td>
                                                <a href="editbudget.php?id=' . $row['budget_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                                                <a href="budgetanalysis.php?id=' . $row['budget_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-bar-chart"></i> Analysis</a>
                                                <a href="budgetlines.php?budget_id=' . $row['budget_id'] . '" class="btn btn-primary btn-xs"><i class="fa fa-list"></i> Lines</a>';
                                        if (canApprovePayments($_SESSION['schoolsyslevel']) && $row['status'] == 'Submitted') {
                                            echo '<a href="approvebudget.php?id=' . $row['budget_id'] . '" class="btn btn-success btn-xs" onclick="return confirm(\'Approve this budget?\')"><i class="fa fa-check"></i></a>';
                                        }
                                        echo '</td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="9" class="text-center">No budgets found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
