<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
if (!isset($_SESSION['schoolsyslevel']) || !canManageBudgets($_SESSION['schoolsyslevel'])) {
  header('Location:login.php');
  exit;
}

$budget_id = isset($_GET['budget_id']) ? (int)$_GET['budget_id'] : 0;
if ($budget_id <= 0) { header('Location: budgets.php'); exit; }

// fetch budget summary
$bal_stmt = mysqli_prepare($con, "SELECT budget_id,budget_name,total_budget,allocated_amount,spent_amount,remaining_amount FROM budgets WHERE budget_id=? LIMIT 1");
if (!$bal_stmt) { header('Location: budgets.php'); exit; }
mysqli_stmt_bind_param($bal_stmt,'i',$budget_id);
mysqli_stmt_execute($bal_stmt);
$bal_res = mysqli_stmt_get_result($bal_stmt);
$budget = mysqli_fetch_assoc($bal_res);
mysqli_stmt_close($bal_stmt);
if (!$budget) { header('Location: budgets.php'); exit; }

// Check for budget_lines table
$has_lines_table = false;
$chk = mysqli_query($con, "SHOW TABLES LIKE 'budget_lines'");
if ($chk && mysqli_num_rows($chk) > 0) $has_lines_table = true;

$lines = [];
// Helper to pick first existing column from a list
function pick_column(array $row, array $candidates) {
  foreach ($candidates as $c) {
    if (array_key_exists($c, $row)) return $row[$c];
  }
  return null;
}

if ($has_lines_table) {
  // Use a generic SELECT * to avoid assumptions about column names
  $q = mysqli_prepare($con, "SELECT * FROM budget_lines WHERE budget_id = ? ORDER BY 1");
  if ($q) {
    mysqli_stmt_bind_param($q,'i',$budget_id);
    mysqli_stmt_execute($q);
    $r = mysqli_stmt_get_result($q);
    while ($ln = mysqli_fetch_assoc($r)) { $lines[] = $ln; }
    mysqli_stmt_close($q);
  } else {
    // fallback to non-prepared select
    $res = mysqli_query($con, "SELECT * FROM budget_lines WHERE budget_id = " . (int)$budget_id);
    if ($res) {
      while ($ln = mysqli_fetch_assoc($res)) { $lines[] = $ln; }
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Budget Lines - <?php echo htmlspecialchars($budget['budget_name']); ?></title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-10 col-lg-offset-1">
        <section class="panel">
          <header class="panel-heading">Budget Lines: <?php echo htmlspecialchars($budget['budget_name']); ?></header>
          <div class="panel-body">
            <p>Total: <?php echo number_format($budget['total_budget'],2); ?> | Allocated: <?php echo number_format($budget['allocated_amount'],2); ?> | Spent: <?php echo number_format($budget['spent_amount'],2); ?> | Remaining: <?php echo number_format($budget['remaining_amount'],2); ?></p>

            <?php if (!$has_lines_table): ?>
              <div class="alert alert-info">No `budget_lines` table found. Create a `budget_lines` table with columns (line_id, budget_id, description, amount, spent) to store lines.</div>
            <?php else: ?>
              <?php if (empty($lines)): ?>
                <div class="alert alert-warning">No lines found for this budget.</div>
              <?php else: ?>
                <table class="table table-bordered">
                  <thead><tr><th>#</th><th>Description</th><th>Amount</th><th>Spent</th><th>Remaining</th></tr></thead>
                  <tbody>
                  <?php foreach ($lines as $ln): ?>
                    <tr>
                      <td><?php echo (int)$ln['line_id']; ?></td>
                      <td><?php echo htmlspecialchars($ln['description']); ?></td>
                      <td><?php echo number_format($ln['amount'],2); ?></td>
                      <td><?php echo number_format($ln['spent'],2); ?></td>
                      <td><?php echo number_format(((float)$ln['amount'] - (float)$ln['spent']),2); ?></td>
                    </tr>
                  <?php endforeach; ?>
                  </tbody>
                </table>
              <?php endif; ?>
            <?php endif; ?>

            <a href="budgets.php" class="btn btn-default">Back</a>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>