<?php
include 'includes/conn.php';
include 'includes/roles.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if (!canManageBudgets($user_level)) {
  header('Location:login.php');
  exit;
}

$budget_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($budget_id <= 0) { header('Location: budgets.php'); exit; }

// fetch budget
$stmt = mysqli_prepare($con, "SELECT budget_id,budget_name,department,fiscal_year,total_budget,allocated_amount,spent_amount,remaining_amount,status FROM budgets WHERE budget_id = ? LIMIT 1");
if (!$stmt) { header('Location: budgets.php'); exit; }
mysqli_stmt_bind_param($stmt,'i',$budget_id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$budget = mysqli_fetch_assoc($res);
mysqli_stmt_close($stmt);
if (!$budget) { header('Location: budgets.php'); exit; }

// guard defaults
$budget = array_merge([
  'budget_id'=>0,'budget_name'=>'','department'=>'','fiscal_year'=>'','total_budget'=>0.0,'allocated_amount'=>0.0,'spent_amount'=>0.0,'remaining_amount'=>0.0,'status'=>''
], (array)$budget);

// derived
$total = (float)$budget['total_budget'];
$spent = (float)$budget['spent_amount'];
$allocated = (float)$budget['allocated_amount'];
$remaining = (float)$budget['remaining_amount'];
$pct_used = $total > 0 ? round(($spent / $total) * 100, 1) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Budget Analysis - <?php echo htmlspecialchars($budget['budget_name']); ?></title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/style-responsive.css">
  <style> .stat { font-size:1.2em; margin-bottom:8px; } .big { font-weight:bold; font-size:1.6em; } </style>
</head>
<body class="sticky-header">
<section>
  <?php include 'includes/header.php'; ?>
  <section class="wrapper">
    <div class="row">
      <div class="col-lg-8 col-lg-offset-2">
        <section class="panel">
          <header class="panel-heading">Budget Analysis: <?php echo htmlspecialchars($budget['budget_name']); ?></header>
          <div class="panel-body">
            <p class="stat">Department: <?php echo htmlspecialchars($budget['department'] ?: '-'); ?></p>
            <p class="stat">Fiscal Year: <?php echo htmlspecialchars($budget['fiscal_year'] ?: '-'); ?></p>
            <p class="stat big">Total Budget: <?php echo number_format($total,2); ?></p>
            <p class="stat">Allocated: <?php echo number_format($allocated,2); ?></p>
            <p class="stat">Spent: <?php echo number_format($spent,2); ?></p>
            <p class="stat">Remaining: <?php echo number_format($remaining,2); ?></p>
            <p class="stat">Percent Used: <strong><?php echo $pct_used; ?>%</strong></p>

            <hr>
            <a href="budgets.php" class="btn btn-default">Back to Budgets</a>
            <a href="budgetlines.php?budget_id=<?php echo $budget['budget_id']; ?>" class="btn btn-primary">View Budget Lines</a>
          </div>
        </section>
      </div>
    </div>
  </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>