<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
include 'includes/conn.php';
// require admin or librarian (level 1 or 5)
if (!isset($_SESSION['schoolsyslevel']) || ( (int)$_SESSION['schoolsyslevel'] !== 1 && (int)$_SESSION['schoolsyslevel'] !== 5 )) {
  header('Location:login.php');
  exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT) ?: 0;
if ($id <= 0) {
  header('Location: books.php');
  exit;
}
?>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Confirm Book Return-School Manager</title>
            <link href="css/chosen/chosen.css" rel="stylesheet">
   <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>


</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
         <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Book Details
                    </header>
                          <div class="panel-body">
                                    <div class="feed-element">
                                                                              <div class="media-body ">
                                               <table  class="display table  table-striped" id="dynamic-table">
        <tbody>
    
         <?php
    // fetch issued book safely
    $issue_id = 0;
    $book_id = 0;
    $date = 0;
    $due = 0;
    $serial = '';
    $status = 0;
    $borrower = '';
    $student_id = 0;
    $bookname = '';
    $author = '';
    $fullname = '';

    $ib_stmt = mysqli_prepare($con, "SELECT issue_id, book_id, `date`, duedate, serial, status, borrower, student_id FROM issuedbooks WHERE issue_id = ? LIMIT 1");
    if ($ib_stmt) {
      mysqli_stmt_bind_param($ib_stmt, 'i', $id);
      mysqli_stmt_execute($ib_stmt);
      mysqli_stmt_bind_result($ib_stmt, $issue_id_result, $book_id_result, $date_result, $due_result, $serial_result, $status_result, $borrower_result, $student_id_result);
      if (mysqli_stmt_fetch($ib_stmt)) {
        $issue_id = (int)$issue_id_result;
        $book_id = (int)$book_id_result;
        $date = (int)$date_result;
        $due = (int)$due_result;
        $serial = $serial_result;
        $status = (int)$status_result;
        $borrower = $borrower_result;
        $student_id = (int)$student_id_result;
      }
      mysqli_stmt_close($ib_stmt);
    } else {
      $qid = (int)$id;
      $issuedbooks = mysqli_query($con, "SELECT * FROM issuedbooks WHERE issue_id='$qid'");
      if ($issuedbooks && mysqli_num_rows($issuedbooks) > 0) {
        $row = mysqli_fetch_assoc($issuedbooks);
        $issue_id = (int)($row['issue_id'] ?? 0);
        $book_id = (int)($row['book_id'] ?? 0);
        $date = (int)($row['date'] ?? 0);
        $due = (int)($row['duedate'] ?? 0);
        $serial = $row['serial'] ?? '';
        $status = (int)($row['status'] ?? 0);
        $borrower = $row['borrower'] ?? '';
        $student_id = (int)($row['student_id'] ?? 0);
      }
    }

    // fetch book details safely
    if ($book_id > 0) {
      $bstmt = mysqli_prepare($con, "SELECT book_title, author FROM books WHERE book_id = ? LIMIT 1");
      if ($bstmt) {
        mysqli_stmt_bind_param($bstmt, 'i', $book_id);
        mysqli_stmt_execute($bstmt);
        mysqli_stmt_bind_result($bstmt, $bookname_result, $author_result);
        if (mysqli_stmt_fetch($bstmt)) {
          $bookname = $bookname_result;
          $author = $author_result;
        }
        mysqli_stmt_close($bstmt);
      } else {
        $bid = (int)$book_id;
        $books = mysqli_query($con, "SELECT * FROM books WHERE book_id='$bid'");
        if ($books && mysqli_num_rows($books) > 0) {
          $row1 = mysqli_fetch_assoc($books);
          $bookname = $row1['book_title'] ?? '';
          $author = $row1['author'] ?? '';
        }
      }
    }

    // fetch borrower name
    if ($borrower === 'student' && $student_id > 0) {
      $sstmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ? LIMIT 1");
      if ($sstmt) {
        mysqli_stmt_bind_param($sstmt, 'i', $student_id);
        mysqli_stmt_execute($sstmt);
        mysqli_stmt_bind_result($sstmt, $fullname_result);
        if (mysqli_stmt_fetch($sstmt)) {
          $fullname = $fullname_result;
        }
        mysqli_stmt_close($sstmt);
      } else {
        $sid = (int)$student_id;
        $getstudent = mysqli_query($con, "SELECT * FROM students WHERE student_id='$sid'");
        if ($getstudent && mysqli_num_rows($getstudent) > 0) {
          $row2 = mysqli_fetch_assoc($getstudent);
          $fullname = $row2['fullname'] ?? '';
        }
      }
    } elseif ($student_id > 0) {
      $tstmt = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE teacher_id = ? LIMIT 1");
      if ($tstmt) {
        mysqli_stmt_bind_param($tstmt, 'i', $student_id);
        mysqli_stmt_execute($tstmt);
        mysqli_stmt_bind_result($tstmt, $fullname_result2);
        if (mysqli_stmt_fetch($tstmt)) {
          $fullname = $fullname_result2;
        }
        mysqli_stmt_close($tstmt);
      } else {
        $tid = (int)$student_id;
        $employee = mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id='$tid'");
        if ($employee && mysqli_num_rows($employee) > 0) {
          $row2 = mysqli_fetch_assoc($employee);
          $fullname = $row2['fullname'] ?? '';
        }
      }
    }
                   ?>
              <tr>    <th>Book Title</th>  <td><?php echo htmlspecialchars($bookname, ENT_QUOTES); ?></td><tr>
                     <tr> <th>Serial No</th> <td><?php echo htmlspecialchars($serial, ENT_QUOTES); ?></td></tr>
                 <tr><th>Date Borrowed</th>   <td><?php echo htmlspecialchars(date('d/M/Y', (int)$date), ENT_QUOTES); ?></td></tr>
                 <tr><th>Expected Return Date</th>  <td><?php echo htmlspecialchars(date('d/M/Y', (int)$due), ENT_QUOTES); ?></td></tr>
                   <tr> <th>Issued To</th>  <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td></tr>
                                                                          
                                                 
                                        
        </tbody>
                                               </table>
    
                    
                 
                          </div>
                          </div>
                          </div>
                          </div>
    <div class="col-lg-6">
                      <section class="panel">
                    <header class="panel-heading">
                    Confirm Book Return
                    </header>
                          <div class="panel-body">      
 <?php
   if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['returndate'])) {
     $rd_raw = trim($_POST['returndate']);
     $returndate_ts = $rd_raw !== '' ? strtotime($rd_raw) : 0;
     if ($returndate_ts <= 0) {
       echo '<div class="alert alert-danger">Oops!! Date Not Selected or invalid</div>';
     } else {
       // update issuedbooks using prepared statement with fallback
       $upd = mysqli_prepare($con, "UPDATE issuedbooks SET status = 1, returndate = ? WHERE issue_id = ?");
       if ($upd) {
         mysqli_stmt_bind_param($upd, 'ii', $returndate_ts, $issue_id);
         $ok = mysqli_stmt_execute($upd);
         mysqli_stmt_close($upd);
         if ($ok) {
           echo '<div class="alert alert-success">Book Return successfully Confirmed</div>';
         } else {
           echo '<div class="alert alert-danger">Failed to confirm return</div>';
         }
       } else {
         $rd_e = (int)$returndate_ts;
         $iid = (int)$issue_id;
         if (mysqli_query($con, "UPDATE issuedbooks SET status='1', returndate='$rd_e' WHERE issue_id='$iid'")) {
           echo '<div class="alert alert-success">Book Return successfully Confirmed</div>';
         } else {
           echo '<div class="alert alert-danger">Failed to confirm return</div>';
         }
       }
     }
   }
                  ?>
                        
     <form method="post" name='form' class="forml" action=""  enctype="multipart/form-data">
                               
                             
                            
                                 <div class="hr-line-dashed"></div>
                                     <div class="form-group" id="data_1">
                               <label class=" control-label">* Enter Return Date </label>
                         <div class="input-group date">
                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span><input type="text" class="form-control" name="returndate" placeholder="select date" required="required">
                                                                </div>
                            </div>
                                                                               
                                <div class="form-group">
                            
                                   
                                        <button class="btn btn-primary" type="submit">Submit</button>
                          
                                </div>
                            </form>
                    </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
 <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>
<script>
  $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });   
</script>