<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Check authorization (allow Accounts Management role 3 as well)
if (!hasFinancialAccess($user_level) && $user_level !== 3) {
    header('Location:login.php');
    exit();
}

$filter_status = $_GET['status'] ?? '';
$filter_account = (int)($_GET['account'] ?? 0);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Bank Transactions</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-building-o"></i> Bank Transactions
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <a href="addbanktransaction.php" class="btn btn-primary btn-sm margin-bottom-10">
                            <i class="fa fa-plus"></i> Record New Transaction
                        </a>
                        <a href="bankaccounts.php" class="btn btn-info btn-sm margin-bottom-10">
                            <i class="fa fa-cog"></i> Manage Bank Accounts
                        </a>
                        
                        <!-- Filters -->
                        <div class="row margin-bottom-20">
                            <div class="col-md-3">
                                <select id="filter-account" class="form-control">
                                    <option value="">All Bank Accounts</option>
                                    <?php
                                    $accounts = mysqli_query($con, "SELECT * FROM bank_accounts WHERE status=1");
                                    while ($acc = mysqli_fetch_array($accounts)) {
                                        echo '<option value="' . $acc['bank_account_id'] . '">' . htmlspecialchars($acc['bank_name'] . ' - ' . $acc['account_number']) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select id="filter-status" class="form-control">
                                    <option value="">All Status</option>
                                    <option value="Pending">Pending</option>
                                    <option value="Completed">Completed</option>
                                    <option value="Failed">Failed</option>
                                    <option value="Reconciled">Reconciled</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <input type="text" id="filter-date" class="form-control" placeholder="Filter by date range">
                            </div>
                        </div>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Bank Account</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Reference</th>
                                    <th>Status</th>
                                    <th>Balance After</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT bt.*, ba.bank_name, ba.account_number 
                                         FROM bank_transactions bt 
                                         LEFT JOIN bank_accounts ba ON bt.bank_account_id = ba.bank_account_id 
                                         WHERE 1=1";
                                
                                if ($filter_account) $query .= " AND bt.bank_account_id = $filter_account";
                                if ($filter_status) $query .= " AND bt.status = '$filter_status'";
                                
                                $query .= " ORDER BY bt.transaction_date DESC, bt.transaction_time DESC";
                                
                                $result = mysqli_query($con, $query);
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        $status_class = 'label-warning';
                                        if ($row['status'] == 'Completed') $status_class = 'label-success';
                                        elseif ($row['status'] == 'Failed') $status_class = 'label-danger';
                                        elseif ($row['status'] == 'Reconciled') $status_class = 'label-info';
                                        
                                        $type_class = 'text-success';
                                        if ($row['transaction_type'] == 'Withdrawal' || $row['transaction_type'] == 'Fee') $type_class = 'text-danger';
                                        
                                        echo '<tr>
                                            <td>' . date('d/M/Y', strtotime($row['transaction_date'])) . '</td>
                                            <td>' . htmlspecialchars($row['bank_name']) . '<br><small>' . $row['account_number'] . '</small></td>
                                            <td><span class="' . $type_class . '">' . htmlspecialchars($row['transaction_type']) . '</span></td>
                                            <td>' . number_format($row['amount'], 2) . '</td>
                                            <td>' . htmlspecialchars($row['reference_number'] ?? '-') . '</td>
                                            <td><span class="label ' . $status_class . '">' . htmlspecialchars($row['status']) . '</span></td>
                                            <td>' . number_format($row['balance_after'] ?? 0, 2) . '</td>
                                            <td>
                                                <a href="editbanktransaction.php?id=' . $row['transaction_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>';
                                        if (hasFullFinancialPermissions($_SESSION['schoolsyslevel'])) {
                                            echo '<a href="deletebanktransaction.php?id=' . $row['transaction_id'] . '" class="btn btn-danger btn-sm" title="Delete transaction" aria-label="Delete transaction" onclick="return confirm(\'Are you sure you want to delete this transaction?\')"><i class="fa fa-trash"></i> Delete</a>';
                                        }
                                        echo '</td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="8" class="text-center">No transactions found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
