<?php
include 'includes/conn.php';
include 'includes/roles.php';
// Normalize session role level: support both legacy `secusyslevel` and `schoolsyslevel`
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);

// Check authorization - allow any user with financial access (including Accountant)
// Also allow Accounts Management (role 3)
if (!hasFinancialAccess($user_level) && $user_level !== 3) {
    header('Location:login.php');
    exit();
}

// Handle form submission for adding new account
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add') {
    $bank_name = mysqli_real_escape_string($con, $_POST['bank_name'] ?? '');
    $account_number = mysqli_real_escape_string($con, $_POST['account_number'] ?? '');
    $account_holder = mysqli_real_escape_string($con, $_POST['account_holder'] ?? '');
    $branch = mysqli_real_escape_string($con, $_POST['branch'] ?? '');
    $account_type = mysqli_real_escape_string($con, $_POST['account_type'] ?? 'Current');
    
    if (empty($bank_name) || empty($account_number)) {
        $_SESSION['message'] = 'Bank name and account number are required';
        $_SESSION['msg_type'] = 'danger';
    } else {
        $query = "INSERT INTO bank_accounts (bank_name, account_number, account_holder, branch, account_type, status)
                  VALUES ('$bank_name', '$account_number', '$account_holder', '$branch', '$account_type', 1)";
        
        if (mysqli_query($con, $query)) {
            $_SESSION['message'] = 'Bank account added successfully';
            $_SESSION['msg_type'] = 'success';
        } else {
            $_SESSION['message'] = 'Error: ' . mysqli_error($con);
            $_SESSION['msg_type'] = 'danger';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Bank Accounts Management</title>
    <link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title">
                            <i class="fa fa-university"></i> Bank Accounts Management
                        </h4>
                    </header>
                    <div class="panel-body">
                        <?php
                        if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . ' alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    ' . htmlspecialchars($_SESSION['message']) . '
                                 </div>';
                            unset($_SESSION['message']);
                            unset($_SESSION['msg_type']);
                        }
                        ?>
                        
                        <!-- Add New Account Modal Button -->
                        <button type="button" class="btn btn-primary btn-sm margin-bottom-10" data-toggle="modal" data-target="#addAccountModal">
                            <i class="fa fa-plus"></i> Add New Bank Account
                        </button>
                        
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>Bank Name</th>
                                    <th>Account Number</th>
                                    <th>Account Holder</th>
                                    <th>Branch</th>
                                    <th>Type</th>
                                    <th>Current Balance</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT * FROM bank_accounts ORDER BY status DESC, created_at DESC";
                                $result = mysqli_query($con, $query);
                                
                                if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_array($result)) {
                                        echo '<tr>
                                            <td>' . htmlspecialchars($row['bank_name']) . '</td>
                                            <td>' . htmlspecialchars($row['account_number']) . '</td>
                                            <td>' . htmlspecialchars($row['account_holder'] ?? '-') . '</td>
                                            <td>' . htmlspecialchars($row['branch'] ?? '-') . '</td>
                                            <td>' . htmlspecialchars($row['account_type']) . '</td>
                                            <td><strong>' . number_format($row['balance'], 2) . ' ' . $row['currency'] . '</strong></td>
                                            <td><span class="label ' . ($row['status'] == 1 ? 'label-success' : 'label-danger') . '">' . ($row['status'] == 1 ? 'Active' : 'Inactive') . '</span></td>
                                            <td>
                                                <a href="editbankaccount.php?id=' . $row['bank_account_id'] . '" class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                                                <a href="transactionsbyaccount.php?id=' . $row['bank_account_id'] . '" class="btn btn-success btn-xs"><i class="fa fa-list"></i> Transactions</a>
                                            </td>
                                        </tr>';
                                    }
                                } else {
                                    echo '<tr><td colspan="8" class="text-center">No bank accounts found</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<!-- Add Bank Account Modal -->
<div class="modal fade" id="addAccountModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Bank Account</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add">
                    
                    <div class="form-group">
                        <label class="control-label">* Bank Name</label>
                        <input type="text" name="bank_name" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="control-label">* Account Number</label>
                        <input type="text" name="account_number" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="control-label">Account Holder Name</label>
                        <input type="text" name="account_holder" class="form-control">
                    </div>
                    
                    <div class="form-group">
                        <label class="control-label">Branch</label>
                        <input type="text" name="branch" class="form-control">
                    </div>
                    
                    <div class="form-group">
                        <label class="control-label">Account Type</label>
                        <select name="account_type" class="form-control">
                            <option value="Current">Current Account</option>
                            <option value="Savings">Savings Account</option>
                            <option value="Investment">Investment Account</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary"><i class="fa fa-check"></i> Add Account</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
