<?php
include 'includes/conn.php';
include 'includes/roles.php';

if (!canViewFinancialReports($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// helper: get current DB name
$dbname = '';
$resdb = mysqli_query($con, "SELECT DATABASE() as db");
if ($resdb) {
    $rowdb = mysqli_fetch_assoc($resdb);
    $dbname = $rowdb['db'] ?? '';
}

function table_sum_from_columns($con, $dbname, $table, $cols) {
    if (empty($dbname)) return 0.0;
    $existing = [];
    foreach ($cols as $c) {
        $c_esc = mysqli_real_escape_string($con, $c);
        $q = "SELECT COUNT(*) as cnt FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".mysqli_real_escape_string($con,$dbname)."' AND TABLE_NAME='".mysqli_real_escape_string($con,$table)."' AND COLUMN_NAME='".$c_esc."'";
        $r = @mysqli_query($con, $q);
        if ($r && ($row = mysqli_fetch_assoc($r)) && (int)$row['cnt'] > 0) {
            $existing[] = $c;
        }
    }
    if (empty($existing)) return 0.0;
    // build COALESCE chain for each column and sum them
    $coalesces = array_map(function($c){ return "COALESCE(`".$c."`,0)"; }, $existing);
    $expr = implode(' + ', $coalesces);
    $sql = "SELECT COALESCE(SUM( ($expr) ), 0) AS total FROM `".mysqli_real_escape_string($con,$table)."`";
    $r = @mysqli_query($con, $sql);
    if (!$r) return 0.0;
    $row = mysqli_fetch_assoc($r);
    return (float)($row['total'] ?? 0);
}

// Assets: try typical columns: value, amount, balance
$assets_total = table_sum_from_columns($con, $dbname, 'assets', ['value','amount','balance']);
// Bank balances: try balance, opening_balance
$bank_total = table_sum_from_columns($con, $dbname, 'bank_accounts', ['balance','opening_balance','account_balance','amount']);
// Accounts receivable (outstanding): sum(amount - amount_paid) or (amount - paid)
$receivables_total = 0.0;
$ra_q_candidates = [
    "SELECT COALESCE(SUM(amount - amount_paid),0) AS total FROM accounts_receivable WHERE status NOT IN ('Paid','Cancelled')",
    "SELECT COALESCE(SUM(amount - paid),0) AS total FROM accounts_receivable WHERE status NOT IN ('Paid','Cancelled')",
    "SELECT COALESCE(SUM(amount),0) AS total FROM accounts_receivable WHERE status NOT IN ('Paid','Cancelled')"
];
foreach ($ra_q_candidates as $q) {
    $r = @mysqli_query($con, $q);
    if ($r) { $row = mysqli_fetch_assoc($r); $receivables_total = (float)($row['total'] ?? 0); break; }
}

// Accounts payable (outstanding liabilities): sum(amount - amount_paid) or amount
$payables_total = 0.0;
$ap_q_candidates = [
    "SELECT COALESCE(SUM(amount - amount_paid),0) AS total FROM accounts_payable WHERE status NOT IN ('Paid','Cancelled')",
    "SELECT COALESCE(SUM(amount - paid),0) AS total FROM accounts_payable WHERE status NOT IN ('Paid','Cancelled')",
    "SELECT COALESCE(SUM(amount),0) AS total FROM accounts_payable WHERE status NOT IN ('Paid','Cancelled')"
];
foreach ($ap_q_candidates as $q) {
    $r = @mysqli_query($con, $q);
    if ($r) { $row = mysqli_fetch_assoc($r); $payables_total = (float)($row['total'] ?? 0); break; }
}

// Other liabilities: fallback to 0 for now
$other_liabilities = 0.0;

// Equity = Assets + Receivables + Bank - Payables - Other Liabilities
$total_assets = $assets_total + $bank_total + $receivables_total;
$total_liabilities = $payables_total + $other_liabilities;
$equity = $total_assets - $total_liabilities;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Balance Sheet</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-balance-scale"></i> Balance Sheet (as at <?php echo htmlspecialchars($end_date); ?>)</h4>
                    </header>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Assets</h5>
                                <ul class="list-group">
                                    <li class="list-group-item">Fixed & Other Assets: <strong><?php echo number_format($assets_total,2); ?></strong></li>
                                    <li class="list-group-item">Bank & Cash: <strong><?php echo number_format($bank_total,2); ?></strong></li>
                                    <li class="list-group-item">Accounts Receivable: <strong><?php echo number_format($receivables_total,2); ?></strong></li>
                                    <li class="list-group-item">Total Assets: <strong><?php echo number_format($total_assets,2); ?></strong></li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Liabilities & Equity</h5>
                                <ul class="list-group">
                                    <li class="list-group-item">Accounts Payable: <strong><?php echo number_format($payables_total,2); ?></strong></li>
                                    <li class="list-group-item">Other Liabilities: <strong><?php echo number_format($other_liabilities,2); ?></strong></li>
                                    <li class="list-group-item">Total Liabilities: <strong><?php echo number_format($total_liabilities,2); ?></strong></li>
                                    <li class="list-group-item">Equity (Assets - Liabilities): <strong><?php echo number_format($equity,2); ?></strong></li>
                                </ul>
                            </div>
                        </div>
                        <p class="margin-top-20">
                            <a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a>
                        </p>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
