<?php
include 'includes/conn.php';
include 'includes/roles.php';
include 'includes/backup_restore.php';

// Only Super Admin
$user_level = (int) ($_SESSION['secusyslevel'] ?? $_SESSION['schoolsyslevel'] ?? 0);
if ($user_level != 1) {
    header('Location: login.php');
    exit();
}

$backup = new DatabaseBackup($con);
$backups = $backup->getAvailableBackups();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backup Management</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-database"></i> Backup Management</h4>
                    </header>
                    <div class="panel-body">
                        <?php if (isset($_SESSION['message'])) {
                            echo '<div class="alert alert-' . (isset($_SESSION['msg_type']) ? $_SESSION['msg_type'] : 'info') . '">' . htmlspecialchars($_SESSION['message']) . '</div>';
                            unset($_SESSION['message']); unset($_SESSION['msg_type']);
                        } ?>

                        <p>
                            <a href="includes/backup_restore.php?action=create" class="btn btn-primary"><i class="fa fa-download"></i> Create Backup Now</a>
                            <a href="systemconfiguration.php" class="btn btn-default">Back to System Configuration</a>
                        </p>

                        <hr />

                        <?php if (empty($backups)) { ?>
                            <div class="alert alert-info">No backups found in the `backups/` directory.</div>
                        <?php } else { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead><tr><th>Filename</th><th>Created</th><th>Size</th><th>Actions</th></tr></thead>
                                    <tbody>
                                    <?php foreach ($backups as $b) { ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($b['filename']); ?></td>
                                            <td><?php echo date('Y-m-d H:i:s', $b['created']); ?></td>
                                            <td><?php echo htmlspecialchars($b['size_formatted']); ?></td>
                                            <td>
                                                <a class="btn btn-success btn-xs" href="downloadbackup.php?file=<?php echo urlencode($b['filename']); ?>">Download</a>
                                                <a class="btn btn-danger btn-xs" href="includes/backup_restore.php?action=delete&file=<?php echo urlencode($b['filename']); ?>" onclick="return confirm('Delete this backup?');">Delete</a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php } ?>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>
