<?php
include 'includes/conn.php';
include 'includes/roles.php';

if (!canViewFinancialReports($_SESSION['schoolsyslevel'])) {
    header('Location:login.php');
    exit();
}

$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-7 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$start_safe = mysqli_real_escape_string($con, $start_date);
$end_safe = mysqli_real_escape_string($con, $end_date);

// Candidate audit tables
$candidates = [
    'audit_trail' => ['user_col' => ['user','username','changed_by','user_id'], 'action_col' => ['action','event','description'], 'date_col' => ['created_at','timestamp','date','time']],
    'audittrail' => ['user_col' => ['user','username','changed_by','user_id'], 'action_col' => ['action','event','description'], 'date_col' => ['created_at','timestamp','date','time']],
    'user_access_log' => ['user_col' => ['user','username','user_id'], 'action_col' => ['action','event','description'], 'date_col' => ['created_at','timestamp','date','time']]
];

function table_exists_local($con, $table){
    $t = mysqli_real_escape_string($con, $table);
    $r = @mysqli_query($con, "SHOW TABLES LIKE '".$t."'");
    return $r && mysqli_num_rows($r) > 0;
}

function find_column_local($con, $db, $table, $candidates){
    foreach ($candidates as $col){
        $colEsc = mysqli_real_escape_string($con, $col);
        $q = "SELECT COUNT(*) AS cnt FROM information_schema.COLUMNS WHERE TABLE_SCHEMA='".mysqli_real_escape_string($con,$db)."' AND TABLE_NAME='".mysqli_real_escape_string($con,$table)."' AND COLUMN_NAME='".$colEsc."'";
        $r = @mysqli_query($con, $q);
        if ($r){ $row = mysqli_fetch_assoc($r); if ((int)$row['cnt'] > 0) return $col; }
    }
    return false;
}

$dbNameRes = mysqli_query($con, "SELECT DATABASE() as db");
$dbName = $dbNameRes ? mysqli_fetch_assoc($dbNameRes)['db'] : '';

$events = [];

foreach ($candidates as $table => $map) {
    if (!table_exists_local($con, $table)) continue;
    $userCol = find_column_local($con, $dbName, $table, $map['user_col']);
    $actionCol = find_column_local($con, $dbName, $table, $map['action_col']);
    $dateCol = find_column_local($con, $dbName, $table, $map['date_col']);

    if (!$actionCol || !$dateCol) continue; // at minimum need action and date

    // Date handling
    $isInt = false;
    $colInfo = @mysqli_query($con, "SHOW COLUMNS FROM `".mysqli_real_escape_string($con,$table)."` LIKE '".mysqli_real_escape_string($con,$dateCol)."'");
    if ($colInfo && ($ci = mysqli_fetch_assoc($colInfo))){ $type = strtolower($ci['Type'] ?? ''); if (strpos($type,'int') !== false) $isInt = true; }

    if ($isInt) {
        $dateExpr = "FROM_UNIXTIME(`".$dateCol."`)";
        $whereDate = "$dateExpr >= '$start_safe' AND $dateExpr <= '$end_safe'";
    } else {
        $dateExpr = "`".$dateCol."`";
        $whereDate = "DATE($dateExpr) >= '$start_safe' AND DATE($dateExpr) <= '$end_safe'";
    }

    $selectParts = [];
    $selectParts[] = $userCol ? "`".$userCol."` AS user_col" : "NULL AS user_col";
    $selectParts[] = "`".$actionCol."` AS action_col";
    $selectParts[] = "$dateExpr AS occurred_at";
    $selectParts[] = "'".mysqli_real_escape_string($con,$table)."' AS source";

    $sql = "SELECT " . implode(', ', $selectParts) . " FROM `".mysqli_real_escape_string($con,$table)."` WHERE " . $whereDate . " ORDER BY occurred_at DESC LIMIT 1000";
    $r = @mysqli_query($con, $sql);
    if ($r){
        while ($row = mysqli_fetch_assoc($r)){
            $dt = $row['occurred_at'] ?? '';
            if (is_numeric($dt)) $dt = date('Y-m-d H:i:s', (int)$dt);
            $events[] = ['user' => $row['user_col'] ?? 'N/A', 'action' => $row['action_col'] ?? '', 'date' => $dt, 'source' => $row['source'] ?? $table];
        }
        break; // use first matching audit table
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="image/png">
    <title>Audit Trail Report</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">
                        <h4 class="panel-title"><i class="fa fa-history"></i> Audit Trail: <?php echo htmlspecialchars($start_date); ?> — <?php echo htmlspecialchars($end_date); ?></h4>
                    </header>
                    <div class="panel-body">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>User</th>
                                    <th>Action</th>
                                    <th>Date</th>
                                    <th>Source</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($events)) { ?>
                                    <tr><td colspan="5">No audit events found for the selected period.</td></tr>
                                <?php } else { $i=1; foreach ($events as $e) { ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        <td><?php echo htmlspecialchars($e['user']); ?></td>
                                        <td><?php echo htmlspecialchars($e['action']); ?></td>
                                        <td><?php echo htmlspecialchars($e['date']); ?></td>
                                        <td><?php echo htmlspecialchars($e['source']); ?></td>
                                    </tr>
                                <?php } } ?>
                            </tbody>
                        </table>

                        <p class="margin-top-20"><a href="financialreports.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>" class="btn btn-default">Back to Reports</a></p>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>
<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/scripts.js"></script>
</body>
</html>
